/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.repository.ui.view;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.List;
import org.eclipse.dirigible.ide.editor.text.input.ContentEditorInput;
import org.eclipse.dirigible.ide.repository.ui.view.Messages;
import org.eclipse.dirigible.repository.api.IResource;
import org.eclipse.dirigible.repository.api.IResourceVersion;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceHistoryView
extends ViewPart {
    private static final String RESOURCE_HISTORY = Messages.ResourceHistoryView_RESOURCE_HISTORY;
    private static final String CREATED_BY = Messages.ResourceHistoryView_CREATED_BY;
    private static final String CREATED_AT = Messages.ResourceHistoryView_CREATED_AT;
    private static final String VERSION = Messages.ResourceHistoryView_VERSION;
    public static final Logger logger = LoggerFactory.getLogger(ResourceHistoryView.class);
    public static final String ID = "org.eclipse.dirigible.ide.repository.ui.view.ResourceHistoryView";
    private TreeViewer viewer;
    private Action doubleClickAction;
    private IResource selectedResource = null;
    private final ISelectionListener selectionListener = new SelectionListenerImpl();

    public void createPartControl(Composite parent) {
        this.viewer = new TreeViewer(parent, 68354);
        this.viewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.viewer.setSorter((ViewerSorter)new VersionSorter());
        Tree tree = this.viewer.getTree();
        tree.setHeaderVisible(true);
        this.createTreeHeader(tree);
        this.viewer.setInput((Object)this.getViewSite());
        this.makeActions();
        this.hookDoubleClickAction();
    }

    private void createTreeHeader(Tree tree) {
        TreeColumn column = new TreeColumn(tree, 16384);
        column.setText(VERSION);
        column.setWidth(70);
        column = new TreeColumn(tree, 16384);
        column.setText(CREATED_AT);
        column.setWidth(250);
        column = new TreeColumn(tree, 16384);
        column.setText(CREATED_BY);
        column.setWidth(300);
    }

    private void makeActions() {
        this.doubleClickAction = new Action(){
            private static final long serialVersionUID = 7611215993365020899L;

            public void run() {
                ISelection selection = ResourceHistoryView.this.viewer.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                if (obj instanceof IResourceVersion) {
                    ResourceHistoryView.this.openEditorForResource((IResourceVersion)obj);
                }
            }
        };
    }

    private boolean openEditorForResource(IResourceVersion file) {
        String editorId = "org.eclipse.dirigible.ide.editor.text.editor.ReadOnlyEditor";
        try {
            ContentEditorInput input = new ContentEditorInput(String.valueOf(file.getVersion()), file.getPath(), file.getContent());
            return ResourceHistoryView.openEditor(editorId, (IEditorInput)input);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            this.showMessage(e.getMessage());
            return false;
        }
    }

    private static boolean openEditor(String id, IEditorInput input) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        try {
            page.openEditor(input, id);
            return true;
        }
        catch (PartInitException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ResourceHistoryView.this.doubleClickAction.run();
            }
        });
    }

    public void showMessage(String message) {
        logger.error(message);
        MessageDialog.openError((Shell)this.viewer.getControl().getShell(), (String)RESOURCE_HISTORY, (String)message);
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    private void handleElementSelected(Object element) {
        if (element instanceof IResource) {
            IResource resource;
            this.selectedResource = resource = (IResource)element;
            this.viewer.refresh();
        }
    }

    private void attachSelectionListener(IWorkbenchPartSite site) {
        if (site == null) {
            return;
        }
        ISelectionService selectionService = this.getSelectionService(site);
        if (selectionService != null) {
            selectionService.addSelectionListener(this.selectionListener);
        }
    }

    private void detachSelectionListener(IWorkbenchPartSite site) {
        if (site == null) {
            return;
        }
        ISelectionService selectionService = this.getSelectionService(site);
        if (selectionService != null) {
            selectionService.removeSelectionListener(this.selectionListener);
        }
    }

    private ISelectionService getSelectionService(IWorkbenchPartSite site) {
        IWorkbenchWindow window = site.getWorkbenchWindow();
        if (window == null) {
            return null;
        }
        return window.getSelectionService();
    }

    public void init(IViewSite site) throws PartInitException {
        this.attachSelectionListener((IWorkbenchPartSite)site);
        super.init(site);
    }

    public void dispose() {
        this.detachSelectionListener(this.getSite());
        super.dispose();
    }

    private class SelectionListenerImpl
    implements ISelectionListener {
        private SelectionListenerImpl() {
        }

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            if (selection instanceof IStructuredSelection) {
                this.selectionChanged((IStructuredSelection)selection);
            }
        }

        private void selectionChanged(IStructuredSelection selection) {
            Object element = selection.getFirstElement();
            if (element != null) {
                ResourceHistoryView.this.handleElementSelected(element);
            }
        }
    }

    class VersionSorter
    extends ViewerSorter {
        private static final long serialVersionUID = 3859467470664110687L;

        VersionSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 == null || e2 == null) {
                return 0;
            }
            if (e1 instanceof IResourceVersion || e2 instanceof IResourceVersion) {
                return ((IResourceVersion)e2).getVersion() - ((IResourceVersion)e1).getVersion();
            }
            return 0;
        }
    }

    class ViewContentProvider
    implements ITreeContentProvider {
        private static final long serialVersionUID = -2635382675151862078L;

        ViewContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            if (ResourceHistoryView.this.selectedResource != null) {
                String error = null;
                try {
                    List resourceVersions = ResourceHistoryView.this.selectedResource.getResourceVersions();
                    if (resourceVersions != null) {
                        return resourceVersions.toArray(new IResourceVersion[0]);
                    }
                    return new IResourceVersion[0];
                }
                catch (IOException e) {
                    error = e.getMessage();
                    logger.error(e.getMessage(), (Throwable)e);
                    return new String[]{error};
                }
            }
            return new IResourceVersion[0];
        }

        public Object[] getChildren(Object parentElement) {
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }
    }

    class ViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private static final long serialVersionUID = -9141488769336871391L;

        ViewLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            if (obj instanceof IResourceVersion) {
                IResourceVersion resourceVersion = (IResourceVersion)obj;
                switch (index) {
                    case 0: {
                        return String.valueOf(resourceVersion.getVersion());
                    }
                    case 1: {
                        return new SimpleDateFormat("yyyy-MM-dd HH-mm-ss").format(resourceVersion.getCreatedAt());
                    }
                    case 2: {
                        return resourceVersion.getCreatedBy();
                    }
                }
            }
            return this.getText(obj);
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }
    }
}

