/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.repository.local;

import org.eclipse.dirigible.repository.local.FileSystemRepository;
import org.eclipse.dirigible.repository.local.LocalBaseException;
import org.eclipse.dirigible.repository.local.LocalObject;

public class LocalFile
extends LocalObject {
    private boolean binary = false;
    private String contentType;

    public LocalFile(FileSystemRepository repository, boolean isBinary, String contentType) {
        super(repository);
        this.binary = isBinary;
        this.contentType = contentType;
    }

    public void delete() throws LocalBaseException {
        this.getRepository().getRepositoryDAO().removeFileByPath(this.getPath());
    }

    public void rename(String newPath) throws LocalBaseException {
        this.getRepository().getRepositoryDAO().renameFile(this.getPath(), newPath);
    }

    public byte[] getData() throws LocalBaseException {
        return this.getRepository().getRepositoryDAO().getFileContent(this);
    }

    public void setData(byte[] content) throws LocalBaseException {
        this.getRepository().getRepositoryDAO().setFileContent(this, content);
    }

    public boolean isBinary() {
        return this.binary;
    }

    public String getContentType() {
        return this.contentType;
    }
}

