/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.log;

import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import org.eclipse.dirigible.repository.logging.ILogListener;
import org.eclipse.dirigible.repository.logging.Logger;

public class WebSocketLogBridgeServletInternal
implements ILogListener {
    private static final Logger logger = Logger.getLogger(WebSocketLogBridgeServletInternal.class);
    private static Map<String, Session> openSessions = new ConcurrentHashMap<String, Session>();

    @OnOpen
    public void onOpen(Session session) throws IOException {
        openSessions.put(session.getId(), session);
        session.getBasicRemote().sendText("[log] open: " + session.getId());
        logger.debug("[ws:log] onOpen: " + session.getId());
    }

    @OnMessage
    public void onMessage(String message, Session session) {
        logger.debug("[ws:log] onMessage: " + message);
    }

    @OnError
    public void onError(Session session, String error) {
        logger.debug("[ws:log] onError: " + error);
    }

    @OnClose
    public void onClose(Session session) {
        openSessions.remove(session.getId());
        logger.debug("[ws:log] onClose: Session " + session.getId() + " has ended");
    }

    public static void sendText(String sessionId, String message) {
        try {
            if (sessionId == null) {
                Iterator<Session> iterator = openSessions.values().iterator();
                while (iterator.hasNext()) {
                    Session element;
                    Session session = element = iterator.next();
                    session.getBasicRemote().sendText(message);
                }
            } else {
                openSessions.get(sessionId).getBasicRemote().sendText(message);
            }
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(String level, String message) {
        for (Session session : openSessions.values()) {
            try {
                Session session2 = session;
                synchronized (session2) {
                    session.getBasicRemote().sendText(String.format("[%s] %s", level, message));
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAll() {
        for (Session session : openSessions.values()) {
            try {
                Session session2 = session;
                synchronized (session2) {
                    session.close();
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }
}

