/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.modules.unittest.ui.views;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;

public class MultiSelectionProvider
implements ISelectionProvider,
ISelectionChangedListener,
FocusListener {
    private final ListenerList fListeners = new ListenerList();
    private final Collection<ISelectionProvider> fBaseProviders = new HashSet<ISelectionProvider>();
    private ISelectionProvider fCurrentProvider;

    public void addSelectionProvider(ISelectionProvider provider) {
        this.fBaseProviders.add(provider);
        provider.addSelectionChangedListener((ISelectionChangedListener)this);
        if (provider instanceof Viewer) {
            ((Viewer)provider).getControl().addFocusListener((FocusListener)this);
        }
        if (this.fCurrentProvider == null) {
            this.fCurrentProvider = provider;
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.fListeners.add((Object)listener);
    }

    public ISelection getSelection() {
        return this.fCurrentProvider.getSelection();
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.fListeners.remove((Object)listener);
    }

    public void setSelection(ISelection selection) {
        this.fCurrentProvider.setSelection(selection);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.fCurrentProvider = event.getSelectionProvider();
        Object[] objectArray = this.fListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((ISelectionChangedListener)listener).selectionChanged(event);
            ++n2;
        }
    }

    public void focusGained(FocusEvent e) {
        Object source = e.getSource();
        for (ISelectionProvider provider : this.fBaseProviders) {
            if (!(provider instanceof Viewer) || !((Viewer)provider).getControl().equals(source)) continue;
            this.selectionChanged(new SelectionChangedEvent(provider, provider.getSelection()));
            break;
        }
    }

    public void focusLost(FocusEvent e) {
    }
}

