/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.lang.python.jython.debugger;

import java.io.InputStream;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.ease.IDebugEngine;
import org.eclipse.ease.Script;
import org.eclipse.ease.ScriptEngineException;
import org.eclipse.ease.debugging.EventDispatchJob;
import org.eclipse.ease.debugging.IEventProcessor;
import org.eclipse.ease.lang.python.jython.JythonScriptEngine;
import org.eclipse.ease.lang.python.jython.debugger.JythonDebugger;
import org.eclipse.ease.lang.python.jython.debugger.ResourceHelper;
import org.eclipse.ease.lang.python.jython.debugger.model.JythonDebugTarget;
import org.python.core.PyObject;

public class JythonDebuggerEngine
extends JythonScriptEngine
implements IDebugEngine {
    private JythonDebugger fDebugger = null;

    public void setDebugger(JythonDebugger debugger) {
        this.fDebugger = debugger;
    }

    protected void setupEngine() throws ScriptEngineException {
        super.setupEngine();
        if (this.fDebugger != null) {
            InputStream stream = ResourceHelper.getResourceStream("org.eclipse.ease.lang.python.jython.debugger", "python/edb.py");
            try {
                super.internalExecute(new Script("Load Python debugger", (Object)stream), null, null);
                Object pyDebugger = this.internalGetVariable("eclipse_jython_debugger");
                if (pyDebugger instanceof PyObject) {
                    this.fDebugger.setupJythonObjects((PyObject)pyDebugger);
                }
            }
            catch (Exception e) {
                throw new ScriptEngineException("Failed to load Python Debugger", (Throwable)e);
            }
        }
    }

    protected Object internalExecute(Script script, Object reference, String fileName) throws Exception {
        if (this.fDebugger != null) {
            return this.fDebugger.execute(script);
        }
        return super.internalExecute(script, reference, fileName);
    }

    public void setupDebugger(ILaunch launch, boolean suspendOnStartup, boolean suspendOnScriptLoad, boolean showDynamicCode) {
        JythonDebugTarget target = new JythonDebugTarget(launch, suspendOnStartup, suspendOnScriptLoad, showDynamicCode);
        launch.addDebugTarget((IDebugTarget)target);
        JythonDebugger debugger = new JythonDebugger(this, showDynamicCode);
        this.setDebugger(debugger);
        EventDispatchJob dispatcher = new EventDispatchJob((IEventProcessor)target, (IEventProcessor)debugger);
        target.setDispatcher(dispatcher);
        debugger.setDispatcher(dispatcher);
        dispatcher.schedule();
    }
}

