/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.scripts.ui;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.ease.tools.ResourceTools;
import org.eclipse.ease.ui.scripts.Activator;
import org.eclipse.ease.ui.scripts.repository.IScript;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class Decorator
implements ILightweightLabelDecorator,
IEclipsePreferences.IPreferenceChangeListener {
    public static final String SIGN_DECORATOR_ID = "org.eclipse.ease.ui.scripts.decorator.signatureState";
    private final ImageDescriptor SIGNED_SCRIPT = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.ease.ui.scripts", (String)"icons/ovr16/signed_script.png");
    private final ImageDescriptor INVALID_SIGNED_SCRIPT = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.ease.ui.scripts", (String)"icons/ovr16/invalid_signed_script.png");
    private final ImageDescriptor BLOCKED_SCRIPT = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.ease.ui.scripts", (String)"icons/ovr16/blocked_script.png");

    public Decorator() {
        Activator.getPrefsNode().addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
        Activator.getPrefsNode().removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public void decorate(Object element, IDecoration decoration) {
        if (element instanceof IScript) {
            IScript iScript = (IScript)element;
            IPreferenceStore prefs = Activator.getDefault().getPreferenceStore();
            boolean run_without_sign_local = prefs.getBoolean("runWithoutSignLocal");
            boolean run_without_sign_remote = prefs.getBoolean("runWithoutSignRemote");
            boolean cfr_ignored_0 = ResourceTools.resolveFile((Object)iScript.getLocation(), null, (boolean)true) instanceof IFile;
            boolean isRemote = iScript.isRemote();
            if (iScript.getSignatureState() != null) {
                decoration.addOverlay(iScript.getSignatureState().booleanValue() ? this.SIGNED_SCRIPT : (isRemote ? (run_without_sign_remote ? this.INVALID_SIGNED_SCRIPT : this.BLOCKED_SCRIPT) : (run_without_sign_local ? this.INVALID_SIGNED_SCRIPT : this.BLOCKED_SCRIPT)));
            }
        }
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        if (event.getKey().equals("runWithoutSignLocal") || event.getKey().equals("runWithoutSignRemote")) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    PlatformUI.getWorkbench().getDecoratorManager().update(Decorator.SIGN_DECORATOR_ID);
                }
            });
        }
    }
}

