/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.sign;

import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Base64;
import org.eclipse.ease.AbstractCodeFactory;
import org.eclipse.ease.ICodeParser;
import org.eclipse.ease.Logger;
import org.eclipse.ease.service.ScriptType;
import org.eclipse.ease.sign.ScriptSignatureException;

public class SignatureHelper {
    private static final String BEGIN_STRING = "-----BEGIN SIGNATURE-----";
    private static final String END_STRING = "-----END SIGNATURE-----";
    private static final String SIGNATURE_TAG = "signature:";
    private static final String CERTIFICATE_TAG = "certificate/s:";
    private static final String HASH_PARAM_TAG = "hash:";
    private static final String PROVIDER_PARAM_TAG = "provider:";
    static final int MAX_LENGTH = 80;
    public static final String DEFAULT_MESSAGE_DIGEST_ALGO = "SHA256";
    public static final String DEFAULT_SIGNATURE_PROVIDER = "preferred";

    public static String convertBytesToBase64(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        Base64.Encoder b = Base64.getEncoder();
        return b.encodeToString(bytes);
    }

    public static byte[] convertBase64ToBytes(String str) {
        if (str == null) {
            return null;
        }
        Base64.Decoder decoder = Base64.getDecoder();
        return decoder.decode(str);
    }

    public static String getSignatureInFormat(ScriptType scriptType, String signStr, String certStr, String messageDigestAlgo, String provider) throws ScriptSignatureException {
        if (scriptType == null || signStr == null || signStr.isEmpty() || certStr == null || certStr.isEmpty()) {
            throw new ScriptSignatureException("One or more parameters are null or empty");
        }
        if (messageDigestAlgo == null || messageDigestAlgo.isEmpty() || "default".equalsIgnoreCase(messageDigestAlgo)) {
            messageDigestAlgo = DEFAULT_MESSAGE_DIGEST_ALGO;
        }
        if (provider == null || provider.isEmpty()) {
            provider = DEFAULT_SIGNATURE_PROVIDER;
        }
        String begin = String.valueOf(AbstractCodeFactory.LINE_DELIMITER) + BEGIN_STRING;
        String end = END_STRING + AbstractCodeFactory.LINE_DELIMITER;
        StringBuffer strBuf = new StringBuffer();
        strBuf.append(begin);
        strBuf.append(AbstractCodeFactory.LINE_DELIMITER);
        strBuf.append(HASH_PARAM_TAG + AbstractCodeFactory.LINE_DELIMITER);
        strBuf.append(String.valueOf(messageDigestAlgo) + AbstractCodeFactory.LINE_DELIMITER);
        strBuf.append(AbstractCodeFactory.LINE_DELIMITER);
        strBuf.append(PROVIDER_PARAM_TAG + AbstractCodeFactory.LINE_DELIMITER);
        strBuf.append(String.valueOf(provider) + AbstractCodeFactory.LINE_DELIMITER);
        strBuf.append(AbstractCodeFactory.LINE_DELIMITER);
        strBuf.append(SIGNATURE_TAG + AbstractCodeFactory.LINE_DELIMITER);
        int i = 0;
        while (i <= signStr.length() - 80) {
            strBuf.append(signStr.substring(i, i + 80));
            strBuf.append(AbstractCodeFactory.LINE_DELIMITER);
            i += 80;
        }
        if (i < signStr.length()) {
            strBuf.append(signStr.substring(i));
        }
        if (i != 80) {
            strBuf.append(AbstractCodeFactory.LINE_DELIMITER);
        }
        strBuf.append(AbstractCodeFactory.LINE_DELIMITER);
        strBuf.append(CERTIFICATE_TAG + AbstractCodeFactory.LINE_DELIMITER);
        i = 0;
        while (i <= certStr.length() - 80) {
            strBuf.append(certStr.substring(i, i + 80));
            strBuf.append(AbstractCodeFactory.LINE_DELIMITER);
            i += 80;
        }
        if (i < certStr.length()) {
            strBuf.append(certStr.substring(i));
        }
        if (i != 80) {
            strBuf.append(AbstractCodeFactory.LINE_DELIMITER);
        }
        strBuf.append(AbstractCodeFactory.LINE_DELIMITER);
        strBuf.append(end);
        return strBuf.toString();
    }

    public static boolean containSignature(ScriptType scriptType, InputStream inputStream) throws ScriptSignatureException {
        ICodeParser iCodeParser = scriptType.getCodeParser();
        return iCodeParser.getSignatureInfo(inputStream) != null;
    }

    public static boolean isSelfSignedCertificate(Certificate certificate) throws ScriptSignatureException {
        if (certificate == null) {
            throw new ScriptSignatureException("Provide appropriate certificate");
        }
        try {
            certificate.verify(certificate.getPublicKey());
            return true;
        }
        catch (CertificateException e) {
            Logger.error("org.eclipse.ease", "Error while parsing certificate.", e);
            throw new ScriptSignatureException("Error while parsing certificate.", e);
        }
        catch (InvalidKeyException e) {
            throw new ScriptSignatureException("Key of the certificate is invalid.", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new ScriptSignatureException("No aprovider support this type of algorithm.", e);
        }
        catch (NoSuchProviderException e) {
            throw new ScriptSignatureException("No provider for this certificate.", e);
        }
        catch (SignatureException signatureException) {
            return false;
        }
    }
}

