/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.lang.javascript.ui;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.ease.lang.javascript.ui.ResourceHyperlink;
import org.eclipse.ease.tools.ResourceTools;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class ResourceHyperlinkDetector
extends AbstractHyperlinkDetector {
    private static final Pattern STRING_LITERAL = Pattern.compile("(?:\"(.*?)\")|(?:'(.*?)')");

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        String line;
        IRegion lineInformation;
        IDocument document = textViewer.getDocument();
        try {
            lineInformation = document.getLineInformationOfOffset(region.getOffset());
            line = document.get(lineInformation.getOffset(), lineInformation.getLength());
        }
        catch (BadLocationException e) {
            return null;
        }
        int offsetInLine = region.getOffset() - lineInformation.getOffset();
        Matcher matcher = STRING_LITERAL.matcher(line);
        while (matcher.find()) {
            Object file;
            if (offsetInLine < matcher.start() || offsetInLine >= matcher.end()) continue;
            String filename = matcher.group(matcher.group(1) != null ? 1 : 2);
            IFile parent = null;
            IEditorInput input = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor().getEditorInput();
            if (input instanceof FileEditorInput) {
                parent = ((FileEditorInput)input).getFile();
            }
            if (!((file = ResourceTools.resolve((Object)filename, parent)) instanceof IFile) || !((IFile)file).exists()) continue;
            Region linkRegion = new Region(lineInformation.getOffset() + matcher.start() + 1, filename.length());
            return new IHyperlink[]{new ResourceHyperlink((IFile)file, (IRegion)linkRegion)};
        }
        return null;
    }
}

