/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.preferences;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ease.modules.ModuleDefinition;
import org.eclipse.ease.ui.Activator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class ModulesLabelProvider
extends LabelProvider {
    private final Map<ImageDescriptor, Image> fImages = new HashMap<ImageDescriptor, Image>();

    public String getText(Object element) {
        if (element instanceof IPath) {
            return ((IPath)element).lastSegment();
        }
        if (element instanceof ModuleDefinition) {
            return ((ModuleDefinition)element).getName();
        }
        return super.getText(element);
    }

    public Image getImage(Object element) {
        if (element instanceof IPath) {
            return Activator.getImage("org.eclipse.ease.ui", "/icons/eobj16/folder.png", true);
        }
        if (element instanceof ModuleDefinition) {
            ImageDescriptor descriptor = ((ModuleDefinition)element).getImageDescriptor();
            if (descriptor != null) {
                if (!this.fImages.containsKey(descriptor)) {
                    this.fImages.put(descriptor, descriptor.createImage());
                }
                return this.fImages.get(descriptor);
            }
            return Activator.getImage("org.eclipse.ease.ui", "/icons/eobj16/module.png", true);
        }
        return super.getImage(element);
    }

    public void dispose() {
        for (Image image : this.fImages.values()) {
            image.dispose();
        }
        super.dispose();
    }
}

