/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.completion;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ease.ICodeParser;
import org.eclipse.ease.ICompletionContext;
import org.eclipse.ease.IScriptEngine;
import org.eclipse.ease.Logger;
import org.eclipse.ease.service.ScriptType;
import org.eclipse.ease.ui.completion.ICompletionProvider;
import org.eclipse.ease.ui.completion.ScriptCompletionProposal;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.text.contentassist.ICompletionProposal;

public class CodeCompletionAggregator
implements IContentProposalProvider {
    public static final String COMPLETION_PROCESSOR = "org.eclipse.ease.ui.codeCompletionProvider";
    public static final String ATTRIBUTE_SCRIPT_TYPE = "scriptType";
    public static final String ATTRIBUTE_CLASS = "class";
    private static final long COMPLETION_TIMEOUT = 500L;
    private ICodeParser fCodeParser;
    private Collection<ICompletionProvider> fCompletionProviders = Collections.emptySet();
    private final Collection<ICompletionProvider> fAddedCompletionProviders = new HashSet<ICompletionProvider>();
    private IScriptEngine fScriptEngine;

    private static Collection<ICompletionProvider> getProviders(String scriptType) {
        IConfigurationElement[] elements;
        HashSet<ICompletionProvider> providers = new HashSet<ICompletionProvider>();
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor(COMPLETION_PROCESSOR);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            String registeredType;
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (scriptType == null || (registeredType = element.getAttribute(ATTRIBUTE_SCRIPT_TYPE)) == null || registeredType.isEmpty() || scriptType.equals(registeredType)) {
                try {
                    Object candidate = element.createExecutableExtension(ATTRIBUTE_CLASS);
                    if (candidate instanceof ICompletionProvider) {
                        providers.add((ICompletionProvider)candidate);
                    }
                }
                catch (CoreException e) {
                    Logger.error((String)"org.eclipse.ease.ui", (String)("Invalid completion provider detected in " + element.getContributor().getName()), (Throwable)e);
                }
            }
            ++n2;
        }
        return providers;
    }

    public void setCodeParser(ICodeParser codeParser) {
        this.fCodeParser = codeParser;
    }

    public char[] getActivationChars() {
        return new char[]{'.'};
    }

    public void setScriptEngine(IScriptEngine scriptEngine) {
        List supportedScriptTypes;
        this.fScriptEngine = scriptEngine;
        if (this.fScriptEngine != null && (supportedScriptTypes = this.fScriptEngine.getDescription().getSupportedScriptTypes()).size() > 0) {
            this.setScriptType((ScriptType)supportedScriptTypes.get(0));
        }
    }

    public void setScriptType(ScriptType scriptType) {
        this.setCodeParser(scriptType.getCodeParser());
        this.fCompletionProviders = CodeCompletionAggregator.getProviders(scriptType.getName());
        this.fCompletionProviders.addAll(this.fAddedCompletionProviders);
    }

    public void addCompletionProvider(ICompletionProvider completionProvider) {
        this.fAddedCompletionProviders.add(completionProvider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ICompletionProposal> getCompletionProposals(final Object resource, final String relevantText, final int insertOffset, final int selectionRange, IProgressMonitor monitor) {
        final LinkedList<ICompletionProposal> proposals = new LinkedList<ICompletionProposal>();
        Job completionProcessorJob = new Job("Calculate EASE code completions"){

            /*
             * Exception decompiling
             */
            protected IStatus run(IProgressMonitor monitor) {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 19[WHILELOOP]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        };
        completionProcessorJob.schedule();
        Job job = completionProcessorJob;
        synchronized (job) {
            try {
                completionProcessorJob.wait(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return proposals;
    }

    private ICompletionContext createContext(Object resource, String relevantText, int insertOffset, int selectionRange) {
        if (this.fCodeParser != null) {
            return this.fCodeParser.getContext(this.fScriptEngine, resource, relevantText, insertOffset, selectionRange);
        }
        return null;
    }

    public IContentProposal[] getProposals(String contents, int position) {
        List<ICompletionProposal> proposals = this.getCompletionProposals(null, contents, position, 0, null);
        Collections.sort(proposals, (o1, o2) -> {
            if (o1 instanceof ScriptCompletionProposal && o1 instanceof ScriptCompletionProposal) {
                return ((ScriptCompletionProposal)o1).compareTo((ScriptCompletionProposal)o2);
            }
            return o1.getDisplayString().compareTo(o2.getDisplayString());
        });
        return proposals.toArray(new IContentProposal[proposals.size()]);
    }

    static /* synthetic */ ICompletionContext access$0(CodeCompletionAggregator codeCompletionAggregator, Object object, String string, int n, int n2) {
        return codeCompletionAggregator.createContext(object, string, n, n2);
    }

    static /* synthetic */ Collection access$1(CodeCompletionAggregator codeCompletionAggregator) {
        return codeCompletionAggregator.fCompletionProviders;
    }
}

