/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.lang.unittest.ui.views;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ease.lang.unittest.runtime.ITestContainer;
import org.eclipse.ease.lang.unittest.runtime.ITestEntity;
import org.eclipse.ease.lang.unittest.runtime.ITestFile;
import org.eclipse.ease.lang.unittest.runtime.ITestSuite;
import org.eclipse.ease.lang.unittest.runtime.TestStatus;
import org.eclipse.ease.lang.unittest.ui.Activator;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.XMLMemento;

public class SuiteRuntimeInformation {
    private static final String XML_PARAMETER_TIMING = "timing";
    private static final String XML_NODE_RUN = "run";
    private static final String XML_NODE_FILE = "entity";
    private static final long DEFAULT_RUNTIME = -1L;
    private static final int RUNS_TO_SAVE = 10;
    private final HashMap<IPath, RuntimeInformation> fRuntimes = new HashMap();
    private final ITestSuite fTestSuite;

    public SuiteRuntimeInformation(ITestSuite testSuite) {
        this.fTestSuite = testSuite;
        this.load();
    }

    private void load() {
        try {
            XMLMemento root = XMLMemento.createReadRoot((Reader)new FileReader(this.getSettingsFile()));
            IMemento[] iMementoArray = root.getChildren(XML_NODE_FILE);
            int n = iMementoArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMemento fileNode = iMementoArray[n2];
                IMemento[] iMementoArray2 = fileNode.getChildren(XML_NODE_RUN);
                int n3 = iMementoArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    IMemento runNode = iMementoArray2[n4];
                    try {
                        this.addTiming((IPath)new Path(fileNode.getTextData()), Long.parseLong(runNode.getString(XML_PARAMETER_TIMING)));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    ++n4;
                }
                ++n2;
            }
            HashSet<ITestSuite> entries = new HashSet<ITestSuite>();
            entries.add(this.fTestSuite);
            while (!entries.isEmpty()) {
                long estimatedDuration;
                ITestEntity candidate = (ITestEntity)entries.iterator().next();
                entries.remove(candidate);
                if (candidate.getEstimatedDuration() < 0L && (estimatedDuration = this.getEstimatedDuration(candidate.getFullPath())) >= 0L) {
                    candidate.setEstimatedDuration(estimatedDuration);
                }
                if (!(candidate instanceof ITestContainer)) continue;
                entries.addAll(((ITestContainer)candidate).getCopyOfChildren());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void save() {
        HashSet<ITestSuite> entries = new HashSet<ITestSuite>();
        entries.add(this.fTestSuite);
        while (!entries.isEmpty()) {
            ITestEntity candidate = (ITestEntity)entries.iterator().next();
            entries.remove(candidate);
            if (candidate instanceof ITestFile && !TestStatus.NOT_RUN.equals((Object)candidate.getEntityStatus())) {
                if (!this.fRuntimes.containsKey(candidate.getFullPath())) {
                    this.fRuntimes.put(candidate.getFullPath(), new RuntimeInformation());
                }
                this.fRuntimes.get(candidate.getFullPath()).addRuntime(candidate.getDuration());
            }
            if (!(candidate instanceof ITestContainer)) continue;
            entries.addAll(((ITestContainer)candidate).getCopyOfChildren());
        }
        FileOutputStream outputStream = null;
        try {
            try {
                outputStream = new FileOutputStream(this.getSettingsFile());
                XMLMemento rootNode = XMLMemento.createWriteRoot((String)"root");
                for (Map.Entry<IPath, RuntimeInformation> entry : this.fRuntimes.entrySet()) {
                    IMemento fileNode = rootNode.createChild(XML_NODE_FILE);
                    fileNode.putTextData(entry.getKey().toString());
                    ArrayList<Long> timings = entry.getValue().getTimings();
                    int index = 0;
                    while (index < Math.min(timings.size(), 10)) {
                        IMemento runNode = fileNode.createChild(XML_NODE_RUN);
                        runNode.putString(XML_PARAMETER_TIMING, Long.toString((Long)timings.get(index)));
                        ++index;
                    }
                }
                rootNode.save((Writer)new OutputStreamWriter(outputStream));
            }
            catch (Exception exception) {
                try {
                    if (outputStream != null) {
                        outputStream.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private synchronized void addTiming(IPath fileIdentifier, long timing) {
        if (!this.fRuntimes.containsKey(fileIdentifier)) {
            this.fRuntimes.put(fileIdentifier, new RuntimeInformation());
        }
        this.fRuntimes.get(fileIdentifier).addRuntime(timing);
    }

    private File getSettingsFile() {
        IPath path = Activator.getDefault().getStateLocation().append("timing_" + this.fTestSuite.getName().hashCode() + ".xml");
        return path.toFile();
    }

    public long getEstimatedDuration(IPath fullPath) {
        RuntimeInformation runtimeInformation = this.fRuntimes.get(fullPath);
        if (runtimeInformation != null) {
            return runtimeInformation.getEstimatedRuntime();
        }
        return -1L;
    }

    private class RuntimeInformation {
        private final ArrayList<Long> fTimings = new ArrayList();

        private RuntimeInformation() {
        }

        public synchronized long getEstimatedRuntime() {
            if (this.fTimings.isEmpty()) {
                return -1L;
            }
            long currentWeight = 100L;
            long totalWeight = 0L;
            long timing = 0L;
            for (long duration : this.fTimings) {
                timing += duration * currentWeight;
                totalWeight += currentWeight;
                currentWeight = (long)((double)currentWeight * 0.7);
            }
            return timing / totalWeight;
        }

        public synchronized void addRuntime(long time) {
            this.fTimings.add(0, time);
        }

        public ArrayList<Long> getTimings() {
            return this.fTimings;
        }
    }
}

