/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.ui.help.hovers.internal;

import org.eclipse.ease.ui.help.hovers.IHoverContentProvider;
import org.eclipse.ease.ui.help.hovers.internal.ControlHoverManager;
import org.eclipse.jface.text.IWidgetTokenOwner;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TableItem;

public class TableViewerHoverManager
extends ControlHoverManager {
    private final TableViewer fTableViewer;

    public TableViewerHoverManager(TableViewer tableViewer, Control hoverArea, IWidgetTokenOwner owner, IHoverContentProvider hoverContent) {
        super((Control)tableViewer.getTable(), hoverArea, owner, hoverContent);
        this.fTableViewer = tableViewer;
    }

    @Override
    protected Rectangle getHoverInterestArea() {
        TableItem item = this.fTableViewer.getTable().getItem(this.getHoverEventLocation());
        Rectangle area = item.getBounds();
        area.x = 0;
        area.width = item.getParent().getBounds().width;
        int offset = 0;
        int[] nArray = this.fTableViewer.getTable().getColumnOrder();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int index = nArray[n2];
            if (offset + this.fTableViewer.getTable().getColumn(index).getWidth() < this.getHoverEventLocation().x) {
                offset += this.fTableViewer.getTable().getColumn(index).getWidth();
            } else {
                area.x = offset;
                area.width = this.fTableViewer.getTable().getColumn(index).getWidth();
                break;
            }
            ++n2;
        }
        return area;
    }

    @Override
    protected Object getHoverOrigin() {
        TableItem item = this.fTableViewer.getTable().getItem(this.getHoverEventLocation());
        return item != null ? this.fTableViewer : null;
    }

    @Override
    protected Object getHoverDetails() {
        TableItem item = this.fTableViewer.getTable().getItem(this.getHoverEventLocation());
        return item != null ? item.getData() : null;
    }
}

