/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.services;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.acceleo.annotations.api.documentation.Documentation;
import org.eclipse.acceleo.annotations.api.documentation.Example;
import org.eclipse.acceleo.annotations.api.documentation.Other;
import org.eclipse.acceleo.annotations.api.documentation.Param;
import org.eclipse.acceleo.annotations.api.documentation.ServiceProvider;
import org.eclipse.acceleo.query.ast.Call;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IService;
import org.eclipse.acceleo.query.runtime.IValidationResult;
import org.eclipse.acceleo.query.runtime.impl.AbstractServiceProvider;
import org.eclipse.acceleo.query.runtime.impl.JavaMethodService;
import org.eclipse.acceleo.query.runtime.impl.Nothing;
import org.eclipse.acceleo.query.runtime.impl.ValidationServices;
import org.eclipse.acceleo.query.services.FilterService;
import org.eclipse.acceleo.query.validation.type.ClassType;
import org.eclipse.acceleo.query.validation.type.EClassifierType;
import org.eclipse.acceleo.query.validation.type.ICollectionType;
import org.eclipse.acceleo.query.validation.type.IType;
import org.eclipse.acceleo.query.validation.type.NothingType;
import org.eclipse.acceleo.query.validation.type.SequenceType;
import org.eclipse.acceleo.query.validation.type.SetType;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;

@ServiceProvider(value="Services available for all types")
public class AnyServices
extends AbstractServiceProvider {
    private static final String LINE_SEP = System.getProperty("line.separator");
    private final IReadOnlyQueryEnvironment queryEnvironment;

    public AnyServices(IReadOnlyQueryEnvironment queryEnvironment) {
        this.queryEnvironment = queryEnvironment;
    }

    @Override
    protected IService getService(Method publicMethod) {
        JavaMethodService result = "oclAsType".equals(publicMethod.getName()) ? new OCLAsTypeService(publicMethod, this) : new JavaMethodService(publicMethod, this);
        return result;
    }

    @Documentation(value="Indicates whether the object \"o1\" is the same as the object \"o2\". For more information refer to the Object#equals(Object) method.", params={@Param(name="o1", value="The object to compare for equality"), @Param(name="o2", value="The reference object with which to compare")}, result="true\" if the object \"o1\" is the same as the object \"o2\", \"false\" otherwise", examples={@Example(expression="'Hello' = 'World'", result="false"), @Example(expression="'Hello' = 'Hello'", result="true")})
    public Boolean equals(Object o1, Object o2) {
        boolean result = o1 == null ? o2 == null : o1.equals(o2);
        return result;
    }

    @Documentation(value="Indicates whether the object \"o1\" is a different object from the object \"o2\".", params={@Param(name="o1", value="The object to compare"), @Param(name="o2", value="The reference object with which to compare")}, result="\"true\" if the object \"o1\" is not the same as the object \"o2\", \"false\" otherwise.", examples={@Example(expression="'Hello' <> 'World'", result="true"), @Example(expression="'Hello' <> 'Hello'", result="false")})
    public Boolean differs(Object o1, Object o2) {
        return this.equals(o1, o2) == false;
    }

    @Documentation(value="Returns the concatenation of self (as a String) and the given string \"s\".", params={@Param(name="self", value="The current object at the end of which to append \"s\"."), @Param(name="s", value="The string we want to append at the end of the current object's string representation.")}, result="The string representation of self for which we added the string \"s\".", examples={@Example(expression="42 + ' times'", result="'42 times'")})
    public String add(Object self, String s) {
        String result = s == null ? this.toString(self) : String.valueOf(this.toString(self)) + s;
        return result;
    }

    @Documentation(value="Returns the concatenation of the current string and the given object \"any\" (as a String).", params={@Param(name="self", value="The current string."), @Param(name="any", value="The object we want to append, as a string, at the end of the current string.")}, result="The current string with the object \"any\" appended (as a String).", examples={@Example(expression="'times ' + 42", result="'times 42'")})
    public String add(String self, Object any) {
        String result = self == null ? this.toString(any) : String.valueOf(self) + this.toString(any);
        return result;
    }

    @Documentation(value="Casts the current object to the given type.", params={@Param(name="object", value="The object to cast"), @Param(name="type", value="The type to cast the object to")}, result="The current object cast to a \"type\"", examples={@Example(expression="anEPackage.oclAsType(ecore::EPackage)", result="anEPackage", others={@Other(language="Acceleo 3 (MTL)", expression="anEPackage.oclAsType(ecore::EPackage)", result="anEPackage")}), @Example(expression="anEPackage.oclAsType(ecore::EClass)", result="anEPackage", others={@Other(language="Acceleo 3 (MTL)", expression="anEPackage.oclAsType(ecore::EClass)", result="oclInvalid")})}, comment="Contrary to Acceleo 3, the type is ignored, the given object will be returned directly.")
    public Object oclAsType(Object object, Object type) {
        if (this.oclIsKindOf(object, type).booleanValue()) {
            return object;
        }
        throw new ClassCastException(object + " cannot be cast to " + type);
    }

    @Documentation(value="Evaluates to \"true\" if the type of the object o1 conforms to the type \"classifier\". That is, o1 is of type \"classifier\" or a subtype of \"classifier\".", params={@Param(name="object", value="The reference Object we seek to test."), @Param(name="type", value="The expected supertype classifier.")}, result="\"true\" if the object o1 is a kind of the classifier, \"false\" otherwise.", examples={@Example(expression="anEPackage.oclIsKindOf(ecore::EPackage)", result="true"), @Example(expression="anEPackage.oclIsKindOf(ecore::ENamedElement)", result="true")})
    public Boolean oclIsKindOf(Object object, Object type) {
        Boolean result;
        if (object == null && type != null) {
            result = false;
        } else if (type instanceof EClass) {
            EClass eClass = (EClass)type;
            result = object instanceof EObject ? Boolean.valueOf(eClass.isInstance(object)) : Boolean.valueOf(false);
        } else if (type instanceof EEnum) {
            if (object instanceof EEnumLiteral) {
                result = ((EEnumLiteral)object).getEEnum().equals(type);
            } else if (object instanceof Enumerator) {
                EEnumLiteral literal = ((EEnum)type).getEEnumLiteral(((Enumerator)object).getName());
                result = literal.getEEnum().equals(type);
            } else {
                result = false;
            }
        } else {
            result = type instanceof EDataType ? Boolean.valueOf(((EDataType)type).isInstance(object)) : (object != null && type instanceof Class ? Boolean.valueOf(((Class)type).isInstance(object)) : Boolean.valueOf(false));
        }
        return result;
    }

    @Documentation(value="Evaluates to \"true\" if the object o1 if of the type \"classifier\" but not a subtype of the \"classifier\".", params={@Param(name="object", value="The reference Object we seek to test."), @Param(name="type", value="The expected type classifier.")}, result="\"true\" if the object o1 is a type of the classifier, \"false\" otherwise.", examples={@Example(expression="anEPackage.oclIsTypeOf(ecore::EPackage)", result="true"), @Example(expression="anEPackage.oclIsTypeOf(ecore::ENamedElement)", result="false")})
    public Boolean oclIsTypeOf(Object object, Object type) {
        Boolean result;
        if (object == null && type != null) {
            result = false;
        } else if (type instanceof EClass) {
            EClass eClass = (EClass)type;
            result = object instanceof EObject ? Boolean.valueOf(eClass == ((EObject)object).eClass()) : Boolean.valueOf(false);
        } else if (type instanceof EEnum) {
            if (object instanceof EEnumLiteral) {
                result = ((EEnumLiteral)object).getEEnum().equals(type);
            } else if (object instanceof Enumerator) {
                EEnumLiteral literal = ((EEnum)type).getEEnumLiteral(((Enumerator)object).getName());
                result = literal.getEEnum().equals(type);
            } else {
                result = false;
            }
        } else {
            result = type instanceof EDataType ? Boolean.valueOf(((EDataType)type).isInstance(object)) : (object != null && type instanceof Class ? Boolean.valueOf(((Class)type).equals(object.getClass())) : Boolean.valueOf(false));
        }
        return result;
    }

    @Documentation(value="Returns a string representation of the current object.", params={@Param(name="self", value="The current object")}, result="a String representation of the given Object. For Collections, this will be the concatenation of all contained Objects' toString.", examples={@Example(expression="42.toString()", result="'42'")})
    public String toString(Object object) {
        String toString;
        StringBuffer buffer = new StringBuffer();
        if (object instanceof Collection) {
            Iterator childrenIterator = ((Collection)object).iterator();
            while (childrenIterator.hasNext()) {
                buffer.append(this.toString(childrenIterator.next()));
            }
        } else if (object != null && !(object instanceof Nothing) && (toString = object.toString()) != null) {
            buffer.append(toString);
        }
        return buffer.toString();
    }

    @Documentation(value="Returns a string representation of the current environment.", params={@Param(name="self", value="The current object")}, result="a string representation of the current environment.", examples={@Example(expression="42.trace()", result="'Metamodels:\n\thttp://www.eclipse.org/emf/2002/Ecore\nServices:\n\torg.eclipse.acceleo.query.services.AnyServices\n\t\tpublic java.lang.String org.eclipse.acceleo.query.services.AnyServices.add(java.lang.Object,java.lang.String)\n\t\t...\nreceiver: 42\n'")})
    public String trace(Object object) {
        StringBuilder result = new StringBuilder();
        result.append("Metamodels:" + LINE_SEP);
        for (EPackage ePgk : this.queryEnvironment.getEPackageProvider().getRegisteredEPackages()) {
            result.append("\t" + ePgk.getNsURI() + LINE_SEP);
        }
        result.append("Services:" + LINE_SEP);
        ArrayList<IService> services = new ArrayList<IService>(this.queryEnvironment.getLookupEngine().getRegisteredServices());
        Collections.sort(services, new Comparator<IService>(){

            @Override
            public int compare(IService service1, IService service2) {
                int result = service1.getPriority() < service2.getPriority() ? -1 : (service1.getPriority() > service2.getPriority() ? 1 : service1.getName().compareTo(service2.getName()));
                return result;
            }
        });
        for (IService service : services) {
            result.append("\t\t" + service.getLongSignature() + LINE_SEP);
        }
        result.append("receiver: ");
        result.append(String.valueOf(this.toString(object)) + LINE_SEP);
        return result.toString();
    }

    private static class OCLAsTypeService
    extends FilterService {
        public OCLAsTypeService(Method publicMethod, Object serviceInstance) {
            super(publicMethod, serviceInstance);
        }

        @Override
        public Set<IType> getType(Call call, ValidationServices services, IValidationResult validationResult, IReadOnlyQueryEnvironment environment, List<IType> argTypes) {
            IType filterType;
            LinkedHashSet<IType> result = new LinkedHashSet<IType>();
            IType receiverType = argTypes.get(0);
            if (services.lower(receiverType, filterType = argTypes.get(1)) != null) {
                Object resultType = filterType.getType();
                if (resultType instanceof EClassifier) {
                    result.add(new EClassifierType(environment, (EClassifier)resultType));
                } else if (resultType instanceof Class) {
                    result.add(new ClassType(environment, (Class)resultType));
                } else if (resultType != null) {
                    result.add(services.nothing("Unknown type %s", resultType));
                } else {
                    result.add(services.nothing("Unknown type %s", "null"));
                }
            } else if (receiverType instanceof EClassifierType && !environment.getEPackageProvider().isRegistered(((EClassifierType)receiverType).getType())) {
                result.add(services.nothing("%s is not registered within the current environment.", receiverType));
            } else if (filterType instanceof EClassifierType && !environment.getEPackageProvider().isRegistered(((EClassifierType)filterType).getType())) {
                result.add(services.nothing("%s is not registered within the current environment.", filterType));
            } else {
                result.add(services.nothing("%s is not compatible with type %s", receiverType, filterType));
                result.addAll(services.intersection(receiverType, filterType));
            }
            return result;
        }

        @Override
        public Set<IType> validateAllType(ValidationServices services, IReadOnlyQueryEnvironment queryEnvironment, Map<List<IType>, Set<IType>> allTypes) {
            LinkedHashSet<IType> result = new LinkedHashSet<IType>();
            StringBuilder builder = new StringBuilder();
            for (Map.Entry<List<IType>, Set<IType>> entry : allTypes.entrySet()) {
                for (IType possibleType : entry.getValue()) {
                    IType rawType = possibleType instanceof ICollectionType ? ((ICollectionType)possibleType).getCollectionType() : possibleType;
                    if (rawType instanceof NothingType) {
                        builder.append("\n");
                        builder.append(((NothingType)rawType).getMessage());
                        continue;
                    }
                    result.add(possibleType);
                }
            }
            if (result.isEmpty()) {
                IType resultType = allTypes.entrySet().iterator().next().getValue().iterator().next();
                NothingType nothing = services.nothing("Nothing will be left after calling %s:" + builder.toString(), this.getName());
                if (resultType instanceof SequenceType) {
                    result.add(new SequenceType(queryEnvironment, nothing));
                } else if (resultType instanceof SetType) {
                    result.add(new SetType(queryEnvironment, nothing));
                } else {
                    result.add(nothing);
                }
            }
            return result;
        }
    }
}

