/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.views.providers.layers;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.sirius.business.api.query.IdentifiedElementQuery;
import org.eclipse.sirius.common.tools.api.util.EqualityHelper;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.description.Layer;
import org.eclipse.sirius.diagram.tools.api.command.ChangeLayerActivationCommand;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.api.editor.DDiagramEditor;
import org.eclipse.sirius.diagram.ui.tools.internal.views.providers.layers.LayersActivationAdapter;
import org.eclipse.sirius.viewpoint.description.IdentifiedElement;
import org.eclipse.swt.widgets.Item;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

public class LayersCellModifier
implements ICellModifier {
    private final LayersActivationAdapter layerActivationAdapter;
    private final IDiagramWorkbenchPart diagramPart;
    private final String[] layerColumns;

    public LayersCellModifier(LayersActivationAdapter adapter, IDiagramWorkbenchPart part, String[] columns) {
        this.layerActivationAdapter = adapter;
        this.diagramPart = part;
        this.layerColumns = columns;
    }

    public boolean canModify(Object element, String property) {
        return property.equals(this.layerColumns[0]);
    }

    public Object getValue(Object element, String property) {
        Layer layer = (Layer)element;
        Object result = null;
        if (property.equals(this.layerColumns[0])) {
            EObject designerElement;
            DiagramEditPart diaEditPart = this.diagramPart.getDiagramEditPart();
            Object obj = diaEditPart.getModel();
            if (obj instanceof View && (designerElement = ((View)obj).getElement()) instanceof DDiagram) {
                EList activatedLayers = ((DDiagram)designerElement).getActivatedLayers();
                result = EqualityHelper.contains((Collection)activatedLayers, (EObject)((EObject)element)) ? Boolean.TRUE : Boolean.FALSE;
            }
        } else {
            result = new IdentifiedElementQuery((IdentifiedElement)layer).getLabel();
        }
        return result;
    }

    public void modify(Object element, String property, Object value) {
        DiagramEditPart diaEditPart;
        Object obj;
        Object objElement = element instanceof Item ? ((Item)element).getData() : element;
        final Layer layer = (Layer)objElement;
        if (property.equals(this.layerColumns[0]) && (obj = (diaEditPart = this.diagramPart.getDiagramEditPart()).getModel()) instanceof View) {
            EObject designerElement = ((View)obj).getElement();
            DDiagramEditor diagramEditor = (DDiagramEditor)this.diagramPart.getDiagramGraphicalViewer().getProperty("org.eclipse.sirius.diagram.ui.part.SiriusDiagramEditorID");
            if (designerElement instanceof DDiagram && diagramEditor != null) {
                final DDiagram dDiagram = (DDiagram)designerElement;
                this.layerActivationAdapter.setPaletteManager(diagramEditor.getPaletteManager());
                IWorkbench wb = PlatformUI.getWorkbench();
                IProgressService ps = wb.getProgressService();
                try {
                    ps.busyCursorWhile(new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            monitor.beginTask(Messages.LayersCellModifier_layerSelectionChangesTaskName, 1);
                            TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)dDiagram);
                            ChangeLayerActivationCommand changeActivatedLayersCmd = new ChangeLayerActivationCommand(domain, dDiagram, layer, monitor);
                            domain.getCommandStack().execute((Command)changeActivatedLayersCmd);
                            monitor.done();
                        }
                    });
                }
                catch (InvocationTargetException e) {
                    if (e.getCause() instanceof RuntimeException) {
                        throw (RuntimeException)e.getCause();
                    }
                    throw new RuntimeException(e.getCause());
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

