/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.core.services.mappingprovider;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecp.common.spi.UniqueSetting;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.mappingprovider.EMFFormsMappingProvider;
import org.eclipse.emfforms.spi.core.services.mappingprovider.EMFFormsMappingProviderManager;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component
public class EMFFormsMappingProviderManagerImpl
implements EMFFormsMappingProviderManager {
    private final Set<EMFFormsMappingProvider> mappingProviders = new LinkedHashSet<EMFFormsMappingProvider>();
    private ReportService reportService;

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addEMFFormsMappingProvider(EMFFormsMappingProvider emfFormsMappingProvider) {
        this.mappingProviders.add(emfFormsMappingProvider);
    }

    protected void removeEMFFormsMappingProvider(EMFFormsMappingProvider emfFormsMappingProvider) {
        this.mappingProviders.remove(emfFormsMappingProvider);
    }

    @Reference(unbind="-")
    protected void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }

    @Override
    public Set<UniqueSetting> getAllSettingsFor(VDomainModelReference domainModelReference, EObject domainObject) {
        EMFFormsMappingProvider bestMappingProvider = null;
        double bestScore = Double.NEGATIVE_INFINITY;
        for (EMFFormsMappingProvider mappingProvider : this.mappingProviders) {
            double score = mappingProvider.isApplicable(domainModelReference, domainObject);
            if (!(score > bestScore)) continue;
            bestMappingProvider = mappingProvider;
            bestScore = score;
        }
        if (bestMappingProvider == null) {
            this.reportService.report(new AbstractReport("Warning: No applicable EMFFormsMappingProvider was found."));
            return Collections.emptySet();
        }
        return bestMappingProvider.getMappingFor(domainModelReference, domainObject);
    }
}

