/**
 * Copyright (c) 2011-2016 EclipseSource Muenchen GmbH and others.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * EclipseSource Munich - initial API and implementation
 */
package org.eclipse.emf.ecp.view.template.style.tab.model.impl;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EPackageImpl;
import org.eclipse.emf.ecp.view.template.model.VTTemplatePackage;
import org.eclipse.emf.ecp.view.template.style.tab.model.TabType;
import org.eclipse.emf.ecp.view.template.style.tab.model.VTTabFactory;
import org.eclipse.emf.ecp.view.template.style.tab.model.VTTabPackage;
import org.eclipse.emf.ecp.view.template.style.tab.model.VTTabStyleProperty;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Package</b>.
 *
 * @since 1.8
 *        <!-- end-user-doc -->
 * @generated
 */
public class VTTabPackageImpl extends EPackageImpl implements VTTabPackage {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	private EClass tabStylePropertyEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	private EEnum tabTypeEEnum = null;

	/**
	 * Creates an instance of the model <b>Package</b>, registered with
	 * {@link org.eclipse.emf.ecore.EPackage.Registry EPackage.Registry} by the package
	 * package URI value.
	 * <p>
	 * Note: the correct way to create the package is via the static
	 * factory method {@link #init init()}, which also performs
	 * initialization of the package, or returns the registered package,
	 * if one already exists.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @see org.eclipse.emf.ecore.EPackage.Registry
	 * @see org.eclipse.emf.ecp.view.template.style.tab.model.VTTabPackage#eNS_URI
	 * @see #init()
	 * @generated
	 */
	private VTTabPackageImpl() {
		super(eNS_URI, VTTabFactory.eINSTANCE);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	private static boolean isInited = false;

	/**
	 * Creates, registers, and initializes the <b>Package</b> for this model, and for any others upon which it depends.
	 *
	 * <p>
	 * This method is used to initialize {@link VTTabPackage#eINSTANCE} when that field is accessed.
	 * Clients should not invoke it directly. Instead, they should simply access that field to obtain the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @see #eNS_URI
	 * @see #createPackageContents()
	 * @see #initializePackageContents()
	 * @generated
	 */
	public static VTTabPackage init() {
		if (isInited) {
			return (VTTabPackage) EPackage.Registry.INSTANCE.getEPackage(VTTabPackage.eNS_URI);
		}

		// Obtain or create and register package
		final VTTabPackageImpl theTabPackage = (VTTabPackageImpl) (EPackage.Registry.INSTANCE
			.get(eNS_URI) instanceof VTTabPackageImpl ? EPackage.Registry.INSTANCE.get(eNS_URI)
				: new VTTabPackageImpl());

		isInited = true;

		// Initialize simple dependencies
		VTTemplatePackage.eINSTANCE.eClass();

		// Create package meta-data objects
		theTabPackage.createPackageContents();

		// Initialize created meta-data
		theTabPackage.initializePackageContents();

		// Mark meta-data to indicate it can't be changed
		theTabPackage.freeze();

		// Update the registry and return the package
		EPackage.Registry.INSTANCE.put(VTTabPackage.eNS_URI, theTabPackage);
		return theTabPackage;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public EClass getTabStyleProperty() {
		return tabStylePropertyEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public EAttribute getTabStyleProperty_Type() {
		return (EAttribute) tabStylePropertyEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 *
	 * @since 1.10
	 *        <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public EAttribute getTabStyleProperty_OkImageURL() {
		return (EAttribute) tabStylePropertyEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 *
	 * @since 1.10
	 *        <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public EAttribute getTabStyleProperty_InfoImageURL() {
		return (EAttribute) tabStylePropertyEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * 
	 * @since 1.10
	 *        <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public EAttribute getTabStyleProperty_WarningImageURL() {
		return (EAttribute) tabStylePropertyEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 *
	 * @since 1.10
	 *        <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public EAttribute getTabStyleProperty_ErrorImageURL() {
		return (EAttribute) tabStylePropertyEClass.getEStructuralFeatures().get(4);
	}

	/**
	 * <!-- begin-user-doc -->
	 *
	 * @since 1.10
	 *        <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public EAttribute getTabStyleProperty_CancelImageURL() {
		return (EAttribute) tabStylePropertyEClass.getEStructuralFeatures().get(5);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public EEnum getTabType() {
		return tabTypeEEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public VTTabFactory getTabFactory() {
		return (VTTabFactory) getEFactoryInstance();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	private boolean isCreated = false;

	/**
	 * Creates the meta-model objects for the package. This method is
	 * guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	public void createPackageContents() {
		if (isCreated) {
			return;
		}
		isCreated = true;

		// Create classes and their features
		tabStylePropertyEClass = createEClass(TAB_STYLE_PROPERTY);
		createEAttribute(tabStylePropertyEClass, TAB_STYLE_PROPERTY__TYPE);
		createEAttribute(tabStylePropertyEClass, TAB_STYLE_PROPERTY__OK_IMAGE_URL);
		createEAttribute(tabStylePropertyEClass, TAB_STYLE_PROPERTY__INFO_IMAGE_URL);
		createEAttribute(tabStylePropertyEClass, TAB_STYLE_PROPERTY__WARNING_IMAGE_URL);
		createEAttribute(tabStylePropertyEClass, TAB_STYLE_PROPERTY__ERROR_IMAGE_URL);
		createEAttribute(tabStylePropertyEClass, TAB_STYLE_PROPERTY__CANCEL_IMAGE_URL);

		// Create enums
		tabTypeEEnum = createEEnum(TAB_TYPE);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	private boolean isInitialized = false;

	/**
	 * Complete the initialization of the package and its meta-model. This
	 * method is guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	public void initializePackageContents() {
		if (isInitialized) {
			return;
		}
		isInitialized = true;

		// Initialize package
		setName(eNAME);
		setNsPrefix(eNS_PREFIX);
		setNsURI(eNS_URI);

		// Obtain other dependent packages
		final VTTemplatePackage theTemplatePackage = (VTTemplatePackage) EPackage.Registry.INSTANCE
			.getEPackage(VTTemplatePackage.eNS_URI);

		// Create type parameters

		// Set bounds for type parameters

		// Add supertypes to classes
		tabStylePropertyEClass.getESuperTypes().add(theTemplatePackage.getStyleProperty());

		// Initialize classes, features, and operations; add parameters
		initEClass(tabStylePropertyEClass, VTTabStyleProperty.class, "TabStyleProperty", !IS_ABSTRACT, !IS_INTERFACE, //$NON-NLS-1$
			IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getTabStyleProperty_Type(), getTabType(), "type", "BOTTOM", 1, 1, VTTabStyleProperty.class, //$NON-NLS-1$ //$NON-NLS-2$
			!IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getTabStyleProperty_OkImageURL(), ecorePackage.getEString(), "okImageURL", null, 0, 1, //$NON-NLS-1$
			VTTabStyleProperty.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE,
			!IS_DERIVED, IS_ORDERED);
		initEAttribute(getTabStyleProperty_InfoImageURL(), ecorePackage.getEString(), "infoImageURL", null, 0, 1, //$NON-NLS-1$
			VTTabStyleProperty.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE,
			!IS_DERIVED, IS_ORDERED);
		initEAttribute(getTabStyleProperty_WarningImageURL(), ecorePackage.getEString(), "warningImageURL", null, 0, 1, //$NON-NLS-1$
			VTTabStyleProperty.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE,
			!IS_DERIVED, IS_ORDERED);
		initEAttribute(getTabStyleProperty_ErrorImageURL(), ecorePackage.getEString(), "errorImageURL", null, 0, 1, //$NON-NLS-1$
			VTTabStyleProperty.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE,
			!IS_DERIVED, IS_ORDERED);
		initEAttribute(getTabStyleProperty_CancelImageURL(), ecorePackage.getEString(), "cancelImageURL", null, 0, 1, //$NON-NLS-1$
			VTTabStyleProperty.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE,
			!IS_DERIVED, IS_ORDERED);

		// Initialize enums and add enum literals
		initEEnum(tabTypeEEnum, TabType.class, "TabType"); //$NON-NLS-1$
		addEEnumLiteral(tabTypeEEnum, TabType.BOTTOM);
		addEEnumLiteral(tabTypeEEnum, TabType.TOP);

		// Create resource
		createResource(eNS_URI);
	}

} // VTTabPackageImpl
