/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.spi.table.celleditor.rcp;

import java.util.concurrent.Semaphore;
import org.eclipse.emf.ecp.view.spi.util.swt.ImageRegistryService;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public final class NativeWidgetHelper {
    private static final String WS_CARBON = "carbon";
    private static final String WS_COCOA = "cocoa";
    private static final String CHECKED_DEFAULT = "icons/checked.png";
    private static final String UNCHECKED_DEFAULT = "icons/unchecked.png";
    private static final Semaphore LOCK = new Semaphore(1, true);
    private static boolean initalized;
    private static ServiceReference<ImageRegistryService> imageRegistryServiceReference;
    private static ImageData checked;
    private static ImageData unchecked;

    private NativeWidgetHelper() {
    }

    public static void initCheckBoxImages(Control control) {
        try {
            try {
                LOCK.acquire();
            }
            catch (InterruptedException ex) {
                if (initalized) {
                    LOCK.release();
                    return;
                }
                NativeWidgetHelper.createCheckBoxImage(control, true);
                NativeWidgetHelper.createCheckBoxImage(control, false);
                initalized = true;
                LOCK.release();
            }
        }
        finally {
            LOCK.release();
        }
    }

    public static Image getCheckBoxImage(Control control, CheckBoxState state) {
        try {
            LOCK.acquire();
            switch (state) {
                case checked: {
                    if (checked != null) {
                        Image image = new Image((Device)control.getDisplay(), checked);
                        return image;
                    }
                    Image image = NativeWidgetHelper.getImage(CHECKED_DEFAULT);
                    return image;
                }
                case unchecked: {
                    if (unchecked != null) {
                        Image image = new Image((Device)control.getDisplay(), unchecked);
                        return image;
                    }
                    Image image = NativeWidgetHelper.getImage(UNCHECKED_DEFAULT);
                    return image;
                }
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            LOCK.release();
        }
        return null;
    }

    private static void createCheckBoxImage(Control control, boolean type) {
        Point bsize;
        Display display = Display.getDefault();
        Color greenScreen = new Color((Device)display, 3, 223, 7);
        Shell shell = new Shell(control.getShell());
        ImageData imageData = null;
        shell.setBackground(greenScreen);
        if (NativeWidgetHelper.isMac()) {
            Button button2 = new Button((Composite)shell, 32);
            bsize = button2.computeSize(-1, -1);
            bsize.x = Math.max(bsize.x - 1, bsize.y - 1);
            bsize.y = Math.max(bsize.x - 1, bsize.y - 1);
            button2.setSize(bsize);
            button2.setLocation(100, 100);
        }
        Button button = new Button((Composite)shell, 32);
        button.setBackground(greenScreen);
        button.setSelection(type);
        button.setLocation(1, 1);
        bsize = button.computeSize(-1, -1);
        bsize.x = Math.max(bsize.x - 1, bsize.y - 1);
        bsize.y = Math.max(bsize.x - 1, bsize.y - 1);
        button.setSize(bsize);
        shell.setSize(bsize);
        shell.setVisible(false);
        shell.open();
        GC gc = new GC((Drawable)shell);
        Image image = new Image((Device)display, bsize.x, bsize.y);
        gc.copyArea(image, 0, 0);
        gc.dispose();
        shell.close();
        imageData = image.getImageData();
        imageData.transparentPixel = imageData.palette.getPixel(greenScreen.getRGB());
        if (type) {
            checked = imageData;
        } else {
            unchecked = imageData;
        }
        image.dispose();
    }

    private static boolean isMac() {
        String ws = SWT.getPlatform();
        return WS_CARBON.equals(ws) || WS_COCOA.equals(ws);
    }

    private static Image getImage(String path) {
        Bundle bundle = FrameworkUtil.getBundle(NativeWidgetHelper.class);
        Image image = NativeWidgetHelper.getImageRegistryService().getImage(bundle, path);
        bundle.getBundleContext().ungetService(imageRegistryServiceReference);
        return image;
    }

    private static ImageRegistryService getImageRegistryService() {
        Bundle bundle = FrameworkUtil.getBundle(NativeWidgetHelper.class);
        if (imageRegistryServiceReference == null) {
            imageRegistryServiceReference = bundle.getBundleContext().getServiceReference(ImageRegistryService.class);
        }
        return (ImageRegistryService)bundle.getBundleContext().getService(imageRegistryServiceReference);
    }

    public static enum CheckBoxState {
        checked,
        unchecked;

    }
}

