/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.core.services.label;

import org.eclipse.core.databinding.observable.IObserving;
import org.eclipse.core.databinding.observable.Observables;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecp.common.spi.asserts.Assert;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedReport;
import org.eclipse.emfforms.spi.core.services.databinding.EMFFormsDatabinding;
import org.eclipse.emfforms.spi.core.services.emfspecificservice.EMFSpecificService;
import org.eclipse.emfforms.spi.core.services.label.EMFFormsLabelProvider;

public class EMFFormsLabelProviderDefaultImpl
implements EMFFormsLabelProvider {
    private EMFFormsDatabinding emfFormsDatabinding;
    private EMFSpecificService emfSpecificService;
    private ReportService reportService;

    protected void setEMFFormsDatabinding(EMFFormsDatabinding emfFormsDatabinding) {
        this.emfFormsDatabinding = emfFormsDatabinding;
    }

    protected void setEMFSpecificService(EMFSpecificService emfSpecificService) {
        this.emfSpecificService = emfSpecificService;
    }

    protected void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }

    public String getDisplayName(EStructuralFeature structuralFeature) {
        EClass eContainingClass = structuralFeature.getEContainingClass();
        if (eContainingClass.isAbstract() || eContainingClass.isInterface() || eContainingClass.getInstanceClass() == null) {
            return this.getFallbackLabel(structuralFeature);
        }
        EObject tempInstance = EcoreUtil.create((EClass)eContainingClass);
        IItemPropertyDescriptor itemPropertyDescriptor = this.emfSpecificService.getIItemPropertyDescriptor(tempInstance, structuralFeature);
        if (itemPropertyDescriptor == null) {
            this.reportMissingPropertyDescriptor(tempInstance, structuralFeature);
            return this.getFallbackLabel(structuralFeature);
        }
        return itemPropertyDescriptor.getDisplayName((Object)tempInstance);
    }

    public IObservableValue getDisplayName(VDomainModelReference domainModelReference) {
        IValueProperty valueProperty;
        Assert.create((Object)domainModelReference).notNull();
        try {
            valueProperty = this.emfFormsDatabinding.getValueProperty(domainModelReference, null);
        }
        catch (DatabindingFailedException ex) {
            this.reportService.report((AbstractReport)new DatabindingFailedReport((Throwable)ex));
            return this.getConstantObservableValue(ex.getMessage());
        }
        EStructuralFeature structuralFeature = (EStructuralFeature)valueProperty.getValueType();
        return this.getConstantObservableValue(this.getDisplayName(structuralFeature));
    }

    private String getFallbackLabel(EStructuralFeature structuralFeature) {
        String[] split = structuralFeature.getName().split("(?<!(^|[A-Z]))(?=[A-Z])|(?<!^)(?=[A-Z][a-z])");
        char[] charArray = split[0].toCharArray();
        charArray[0] = Character.toUpperCase(charArray[0]);
        split[0] = new String(charArray);
        StringBuilder sb = new StringBuilder();
        String[] stringArray = split;
        int n = split.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            sb.append(str);
            sb.append(" ");
            ++n2;
        }
        return sb.toString().trim();
    }

    public IObservableValue getDisplayName(VDomainModelReference domainModelReference, EObject rootObject) {
        IObservableValue observableValue;
        Assert.create((Object)domainModelReference).notNull();
        Assert.create((Object)rootObject).notNull();
        try {
            observableValue = this.emfFormsDatabinding.getObservableValue(domainModelReference, rootObject);
        }
        catch (DatabindingFailedException ex) {
            this.reportService.report((AbstractReport)new DatabindingFailedReport((Throwable)ex));
            return this.getConstantObservableValue(ex.getMessage());
        }
        IObserving observing = (IObserving)observableValue;
        EStructuralFeature structuralFeature = (EStructuralFeature)observableValue.getValueType();
        EObject value = (EObject)observing.getObserved();
        observableValue.dispose();
        IItemPropertyDescriptor itemPropertyDescriptor = this.emfSpecificService.getIItemPropertyDescriptor(value, structuralFeature);
        if (itemPropertyDescriptor == null) {
            this.reportMissingPropertyDescriptor(value, structuralFeature);
            return this.getConstantObservableValue(this.getFallbackLabel(structuralFeature));
        }
        return this.getConstantObservableValue(itemPropertyDescriptor.getDisplayName((Object)value));
    }

    public IObservableValue getDescription(VDomainModelReference domainModelReference) {
        IValueProperty valueProperty;
        Assert.create((Object)domainModelReference).notNull();
        try {
            valueProperty = this.emfFormsDatabinding.getValueProperty(domainModelReference, null);
        }
        catch (DatabindingFailedException ex) {
            this.reportService.report((AbstractReport)new DatabindingFailedReport((Throwable)ex));
            return this.getConstantObservableValue(ex.getMessage());
        }
        EStructuralFeature structuralFeature = (EStructuralFeature)valueProperty.getValueType();
        EClass eContainingClass = structuralFeature.getEContainingClass();
        if (eContainingClass.isAbstract() || eContainingClass.isInterface() || eContainingClass.getInstanceClass() == null) {
            return this.getConstantObservableValue(this.getFallbackLabel(structuralFeature));
        }
        EObject tempInstance = EcoreUtil.create((EClass)eContainingClass);
        IItemPropertyDescriptor itemPropertyDescriptor = this.emfSpecificService.getIItemPropertyDescriptor(tempInstance, structuralFeature);
        if (itemPropertyDescriptor == null) {
            this.reportMissingPropertyDescriptor(tempInstance, structuralFeature);
            return this.getConstantObservableValue(this.getFallbackLabel(structuralFeature));
        }
        return this.getConstantObservableValue(itemPropertyDescriptor.getDescription((Object)tempInstance));
    }

    public IObservableValue getDescription(VDomainModelReference domainModelReference, EObject rootObject) {
        IObservableValue observableValue;
        Assert.create((Object)domainModelReference).notNull();
        Assert.create((Object)rootObject).notNull();
        try {
            observableValue = this.emfFormsDatabinding.getObservableValue(domainModelReference, rootObject);
        }
        catch (DatabindingFailedException ex) {
            this.reportService.report((AbstractReport)new DatabindingFailedReport((Throwable)ex));
            return this.getConstantObservableValue(ex.getMessage());
        }
        IObserving observing = (IObserving)observableValue;
        EStructuralFeature structuralFeature = (EStructuralFeature)observableValue.getValueType();
        EObject value = (EObject)observing.getObserved();
        observableValue.dispose();
        IItemPropertyDescriptor itemPropertyDescriptor = this.emfSpecificService.getIItemPropertyDescriptor(value, structuralFeature);
        if (itemPropertyDescriptor == null) {
            this.reportMissingPropertyDescriptor(value, structuralFeature);
            return this.getConstantObservableValue(this.getFallbackLabel(structuralFeature));
        }
        return this.getConstantObservableValue(itemPropertyDescriptor.getDescription((Object)value));
    }

    private IObservableValue getConstantObservableValue(String value) {
        return Observables.constantObservableValue((Object)value, String.class);
    }

    private void reportMissingPropertyDescriptor(EObject value, EStructuralFeature structuralFeature) {
        this.reportService.report(new AbstractReport(String.format("No IItemPropertyDescriptor for feature %2$s in EClass %1$s found.", value.eClass().getName(), structuralFeature.getName())));
    }
}

