/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.core.services.segments.featurepath;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecp.common.spi.asserts.Assert;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReferenceSegment;
import org.eclipse.emf.ecp.view.spi.model.VFeatureDomainModelReferenceSegment;
import org.eclipse.emf.ecp.view.spi.model.VFeaturePathDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VViewFactory;
import org.eclipse.emf.ecp.view.spi.model.VViewPackage;
import org.eclipse.emfforms.spi.core.services.segments.DmrSegmentGenerator;
import org.osgi.service.component.annotations.Component;

@Component(name="FeaturePathDmrSegmentGenerator")
public class FeaturePathDmrSegmentGenerator
implements DmrSegmentGenerator {
    public double isApplicable(VDomainModelReference reference) {
        Assert.create((Object)reference).notNull();
        if (reference.eClass() == VViewPackage.Literals.FEATURE_PATH_DOMAIN_MODEL_REFERENCE) {
            return 1.0;
        }
        return Double.NEGATIVE_INFINITY;
    }

    public List<VDomainModelReferenceSegment> generateSegments(VDomainModelReference reference) {
        Assert.create((Object)reference).notNull();
        if (reference.eClass() != VViewPackage.Literals.FEATURE_PATH_DOMAIN_MODEL_REFERENCE) {
            throw new IllegalArgumentException(String.format("The given DMR was no feature path domain model reference. The DMR was: %s", reference));
        }
        VFeaturePathDomainModelReference featureDmr = (VFeaturePathDomainModelReference)reference;
        LinkedList<VDomainModelReferenceSegment> result = new LinkedList<VDomainModelReferenceSegment>();
        for (EReference eReference : featureDmr.getDomainModelEReferencePath()) {
            VFeatureDomainModelReferenceSegment segment = VViewFactory.eINSTANCE.createFeatureDomainModelReferenceSegment();
            segment.setDomainModelFeature(eReference.getName());
            result.add((VDomainModelReferenceSegment)segment);
        }
        if (featureDmr.getDomainModelEFeature() != null) {
            VFeatureDomainModelReferenceSegment segment = VViewFactory.eINSTANCE.createFeatureDomainModelReferenceSegment();
            segment.setDomainModelFeature(featureDmr.getDomainModelEFeature().getName());
            result.add((VDomainModelReferenceSegment)segment);
        }
        return result;
    }
}

