/**
 * Copyright (c) 2011-2015 EclipseSource Muenchen GmbH and others.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 * Stefan Dirix - initial API and implementation
 */
package org.eclipse.emf.ecp.emf2web.json.controller.xtend;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecp.emf2web.controller.xtend.GenerationController;
import org.eclipse.emf.ecp.emf2web.controller.xtend.GenerationInfo;
import org.eclipse.emf.ecp.emf2web.json.controller.xtend.ViewCleaner;
import org.eclipse.emf.ecp.emf2web.json.generator.xtend.EcoreJsonGenerator;
import org.eclipse.emf.ecp.emf2web.json.generator.xtend.FormsJsonGenerator;
import org.eclipse.emf.ecp.emf2web.json.util.ReferenceHelperImpl;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.model.VView;

/**
 * @author Stefan Dirix <sdirix@eclipsesource.com>
 */
@SuppressWarnings("all")
public class JsonGenerationController implements GenerationController {
  @Override
  public List<GenerationInfo> generate(final Collection<? extends VView> views) {
    LinkedList<GenerationInfo> _xblockexpression = null;
    {
      final LinkedList<GenerationInfo> result = new LinkedList<GenerationInfo>();
      final EcoreJsonGenerator modelGenerator = new EcoreJsonGenerator();
      final ReferenceHelperImpl helper = new ReferenceHelperImpl();
      final FormsJsonGenerator formsGenerator = new FormsJsonGenerator(helper);
      for (final VView rawView : views) {
        {
          final VView view = EcoreUtil.<VView>copy(rawView);
          EList<String> _ecorePaths = view.getEcorePaths();
          for (final String ecorePath : _ecorePaths) {
            helper.addEcorePath(ecorePath);
          }
          final EClass eClass = view.getRootEClass();
          final String schemaIdentifier = eClass.getName();
          final String schemaFile = modelGenerator.generate(eClass);
          final GenerationInfo schemaInfo = new GenerationInfo(GenerationInfo.MODEL_TYPE, eClass, null, 
            (schemaIdentifier + "Model.json"), null);
          schemaInfo.setGeneratedString(schemaFile);
          result.add(schemaInfo);
          ViewCleaner.cleanView(view);
          final TreeIterator<EObject> allContents = view.eAllContents();
          while (allContents.hasNext()) {
            {
              final EObject next = allContents.next();
              boolean _isInstance = VElement.class.isInstance(next);
              if (_isInstance) {
                VElement _cast = VElement.class.cast(next);
                _cast.setLabel(VElement.class.cast(next).getName());
              }
            }
          }
          final String controllerFile = formsGenerator.generate(view);
          final GenerationInfo controllerInfo = new GenerationInfo(GenerationInfo.VIEW_TYPE, null, view, 
            (schemaIdentifier + "View.json"), null);
          controllerInfo.setGeneratedString(controllerFile);
          result.add(controllerInfo);
        }
      }
      _xblockexpression = result;
    }
    return _xblockexpression;
  }
}
