/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.emf2web.json.controller.xtend;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecp.view.spi.categorization.model.VCategorization;
import org.eclipse.emf.ecp.view.spi.categorization.model.VCategorizationElement;
import org.eclipse.emf.ecp.view.spi.categorization.model.VCategory;
import org.eclipse.emf.ecp.view.spi.label.model.VLabel;
import org.eclipse.emf.ecp.view.spi.model.VContainer;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.model.VView;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;

public class ViewCleaner {
    private static final int VALIDATION_TRIES = 5;

    public static void cleanView(VView view) {
        ViewCleaner.removeInvalidElements(view, 5);
        List whiteList = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Class[]{VLabel.class, VCategorizationElement.class, VCategorization.class, VCategory.class, VView.class, VControl.class, VContainer.class}));
        ViewCleaner.removeUnsupportedElements(view, whiteList);
    }

    private static void removeInvalidElements(VView view, int tries) {
        int i = 0;
        while (i < tries) {
            boolean wasInvalid = ViewCleaner.removeInvalidElements(view);
            if (!wasInvalid) {
                return;
            }
            ++i;
        }
    }

    private static boolean removeInvalidElements(VView view) {
        int _severity_1;
        boolean _equals;
        boolean _xblockexpression = false;
        Diagnostic validation = Diagnostician.INSTANCE.validate((EObject)view);
        int _severity = validation.getSeverity();
        boolean bl = _equals = _severity == 4;
        if (_equals) {
            List _children = validation.getChildren();
            for (Diagnostic diagnostic : _children) {
                ViewCleaner.removeInvalidElements(diagnostic);
            }
        }
        _xblockexpression = (_severity_1 = validation.getSeverity()) == 4;
        return _xblockexpression;
    }

    private static void removeInvalidElements(Diagnostic diagnostic) {
        if (diagnostic.getSeverity() == 4 && !diagnostic.getData().isEmpty() && EObject.class.isInstance(diagnostic.getData().get(0))) {
            Object _get = diagnostic.getData().get(0);
            EcoreUtil.delete((EObject)((EObject)_get));
        }
        List _children = diagnostic.getChildren();
        for (Diagnostic childDiagnostic : _children) {
            ViewCleaner.removeInvalidElements(childDiagnostic);
        }
    }

    private static void removeUnsupportedElements(VView view, List<? extends Class<?>> whiteList) {
        LinkedList<EObject> toDelete = new LinkedList<EObject>();
        TreeIterator allContents = view.eAllContents();
        while (allContents.hasNext()) {
            EObject next = (EObject)allContents.next();
            boolean _isInstance = VElement.class.isInstance(next);
            if (!_isInstance) continue;
            boolean supported = false;
            for (Class<?> element : whiteList) {
                boolean _isInstance_1 = element.isInstance(next);
                if (!_isInstance_1) continue;
                supported = true;
            }
            if (supported) continue;
            toDelete.add(next);
        }
        EcoreUtil.deleteAll(toDelete, (boolean)false);
    }
}

