/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.spi.groupedgrid.swt;

import javax.inject.Inject;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.groupedgrid.model.VGroup;
import org.eclipse.emf.ecp.view.spi.groupedgrid.model.VGroupedGrid;
import org.eclipse.emf.ecp.view.spi.groupedgrid.model.VRow;
import org.eclipse.emf.ecp.view.spi.groupedgrid.model.VSpan;
import org.eclipse.emf.ecp.view.spi.model.LabelAlignment;
import org.eclipse.emf.ecp.view.spi.model.VAttachment;
import org.eclipse.emf.ecp.view.spi.model.VContainedElement;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.renderer.NoPropertyDescriptorFoundExeption;
import org.eclipse.emf.ecp.view.spi.renderer.NoRendererFoundException;
import org.eclipse.emf.ecp.view.spi.swt.reporting.RenderingFailedReport;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.swt.core.AbstractSWTRenderer;
import org.eclipse.emfforms.spi.swt.core.EMFFormsNoRendererException;
import org.eclipse.emfforms.spi.swt.core.EMFFormsRendererFactory;
import org.eclipse.emfforms.spi.swt.core.layout.GridDescriptionFactory;
import org.eclipse.emfforms.spi.swt.core.layout.SWTGridCell;
import org.eclipse.emfforms.spi.swt.core.layout.SWTGridDescription;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class GroupedGridSWTRenderer
extends AbstractSWTRenderer<VGroupedGrid> {
    private SWTGridDescription rendererGridDescription;

    @Inject
    public GroupedGridSWTRenderer(VGroupedGrid vElement, ViewModelContext viewContext, ReportService reportService) {
        super((VElement)vElement, viewContext, reportService);
    }

    public SWTGridDescription getGridDescription(SWTGridDescription gridDescription) {
        if (this.rendererGridDescription == null) {
            this.rendererGridDescription = GridDescriptionFactory.INSTANCE.createSimpleGrid(1, 1, (AbstractSWTRenderer)this);
        }
        return this.rendererGridDescription;
    }

    protected void dispose() {
        this.rendererGridDescription = null;
        super.dispose();
    }

    protected Control renderControl(SWTGridCell cell, Composite parent) throws NoRendererFoundException, NoPropertyDescriptorFoundExeption {
        Composite columnComposite = new Composite(parent, 0);
        columnComposite.setBackground(parent.getBackground());
        int maxNumColumns = this.calculateColumns((VGroupedGrid)this.getVElement());
        GridLayoutFactory.fillDefaults().numColumns(maxNumColumns).equalWidth(true).applyTo(columnComposite);
        for (VGroup group : ((VGroupedGrid)this.getVElement()).getGroups()) {
            Composite labelComposite = new Composite(columnComposite, 0);
            labelComposite.setBackground(parent.getBackground());
            GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).applyTo(labelComposite);
            GridDataFactory.fillDefaults().grab(true, false).align(4, 1).span(maxNumColumns, 1).applyTo((Control)labelComposite);
            Label l = new Label(labelComposite, 0);
            l.setText(group.getName());
            l.setBackground(parent.getBackground());
            GridDataFactory.fillDefaults().grab(false, false).align(1, 1).applyTo((Control)l);
            Label seperator = new Label(labelComposite, 258);
            GridDataFactory.fillDefaults().grab(true, false).align(4, 0x1000000).applyTo((Control)seperator);
            for (VRow row : group.getRows()) {
                int spanned = 0;
                for (VContainedElement child : row.getChildren()) {
                    VControl control;
                    AbstractSWTRenderer renderer;
                    int hSpan = this.getHSpanOfComposite(child);
                    try {
                        renderer = ((EMFFormsRendererFactory)this.getViewModelContext().getService(EMFFormsRendererFactory.class)).getRendererInstance((VElement)child, this.getViewModelContext());
                    }
                    catch (EMFFormsNoRendererException ex) {
                        this.getReportService().report((AbstractReport)new RenderingFailedReport((Throwable)ex));
                        continue;
                    }
                    Control childRender = renderer.render(new SWTGridCell(0, 0, (AbstractSWTRenderer)this), columnComposite);
                    childRender.setBackground(parent.getBackground());
                    GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).indent(0, 0).span(hSpan, 1).applyTo(childRender);
                    GridDataFactory.createFrom((GridData)((GridData)childRender.getLayoutData())).indent(10, 0).applyTo(childRender);
                    spanned += hSpan;
                    if (!VControl.class.isInstance(child) || !this.hasLeftLabelAlignment(control = (VControl)child)) continue;
                    ++spanned;
                }
                int spanDif = maxNumColumns - spanned;
                if (spanDif == 0) continue;
                Label filler = new Label(columnComposite, 0);
                filler.setBackground(parent.getBackground());
                GridDataFactory.fillDefaults().span(spanDif, 1).applyTo((Control)filler);
            }
        }
        return columnComposite;
    }

    private int calculateColumns(VGroupedGrid renderable) {
        int maxColumns = 0;
        for (VGroup group : renderable.getGroups()) {
            for (VRow row : group.getRows()) {
                int columns = 0;
                for (VContainedElement composite : row.getChildren()) {
                    columns += this.getHSpanOfComposite(composite) + this.getExtraColumnForLabel(composite);
                }
                if (columns <= maxColumns) continue;
                maxColumns = columns;
            }
        }
        return maxColumns;
    }

    private int getHSpanOfComposite(VContainedElement composite) {
        for (VAttachment attachment : composite.getAttachments()) {
            if (!VSpan.class.isInstance(attachment)) continue;
            VSpan span = (VSpan)attachment;
            return span.getHorizontalSpan();
        }
        return 1;
    }

    private int getExtraColumnForLabel(VContainedElement child) {
        if (VControl.class.isInstance(child)) {
            VControl control = (VControl)child;
            return this.hasLeftLabelAlignment(control) ? 1 : 0;
        }
        return 0;
    }

    private boolean hasLeftLabelAlignment(VControl control) {
        return control.getLabelAlignment() == LabelAlignment.LEFT || control.getLabelAlignment() == LabelAlignment.DEFAULT;
    }
}

