/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.declaration.delegation;

import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.edapt.declaration.EdaptConstraint;
import org.eclipse.emf.edapt.declaration.EdaptOperation;
import org.eclipse.emf.edapt.declaration.EdaptParameter;
import org.eclipse.emf.edapt.declaration.OperationImplementation;
import org.eclipse.emf.edapt.spi.migration.Instance;
import org.eclipse.emf.edapt.spi.migration.Metamodel;
import org.eclipse.emf.edapt.spi.migration.Model;

@EdaptOperation(identifier="combineFeature", label="Combine Features over References", description="In the metamodel, a number of features are combined in to a single feature by moving it over references to the same class. In the model, the values of the features are moved accordingly.", breaking=true)
public class CombineFeature
extends OperationImplementation {
    @EdaptParameter(main=true, description="The features to be combined")
    public List<EStructuralFeature> features;
    @EdaptParameter(description="The references over which the features are moved (in the same order)")
    public List<EReference> references;

    @EdaptConstraint(description="All references must have the same class as type")
    public boolean checkReferenceSameType() {
        return this.hasSameValue(this.references, (EStructuralFeature)EcorePackage.eINSTANCE.getETypedElement_EType());
    }

    @EdaptConstraint(description="There must be an equal number of features and references")
    public boolean checkFeatureSize() {
        return this.features.size() == this.references.size();
    }

    @EdaptConstraint(description="Each feature has to belong to its reference's class")
    public boolean checkFeatureParent() {
        for (EReference reference : this.references) {
            if (reference.getEContainingClass() == this.features.get(this.references.indexOf(reference)).getEContainingClass()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void execute(Metamodel metamodel, Model model) {
        EClass eClass = this.references.get(0).getEReferenceType();
        EStructuralFeature mainFeature = this.features.get(0);
        eClass.getEStructuralFeatures().add((Object)mainFeature);
        for (EStructuralFeature feature : this.features) {
            if (feature == mainFeature) continue;
            metamodel.delete((EModelElement)feature);
        }
        int i = 0;
        while (i < this.references.size()) {
            EReference reference = this.references.get(i);
            EStructuralFeature feature = this.features.get(i);
            for (Instance instance : model.getAllInstances(reference.getEContainingClass())) {
                Object value = instance.unset(feature);
                Instance ref = (Instance)instance.get((EStructuralFeature)reference);
                if (ref == null) continue;
                ref.set(mainFeature, value);
            }
            ++i;
        }
    }
}

