/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.spi.history.util;

import java.util.Map;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.emf.edapt.spi.history.Add;
import org.eclipse.emf.edapt.spi.history.Change;
import org.eclipse.emf.edapt.spi.history.CompositeChange;
import org.eclipse.emf.edapt.spi.history.ContentChange;
import org.eclipse.emf.edapt.spi.history.Create;
import org.eclipse.emf.edapt.spi.history.Delete;
import org.eclipse.emf.edapt.spi.history.History;
import org.eclipse.emf.edapt.spi.history.HistoryPackage;
import org.eclipse.emf.edapt.spi.history.HistoryPlugin;
import org.eclipse.emf.edapt.spi.history.InitializerChange;
import org.eclipse.emf.edapt.spi.history.MigrateableChange;
import org.eclipse.emf.edapt.spi.history.MigrationChange;
import org.eclipse.emf.edapt.spi.history.ModelReference;
import org.eclipse.emf.edapt.spi.history.Move;
import org.eclipse.emf.edapt.spi.history.NamedElement;
import org.eclipse.emf.edapt.spi.history.NoChange;
import org.eclipse.emf.edapt.spi.history.NonDelete;
import org.eclipse.emf.edapt.spi.history.OperationChange;
import org.eclipse.emf.edapt.spi.history.OperationInstance;
import org.eclipse.emf.edapt.spi.history.ParameterInstance;
import org.eclipse.emf.edapt.spi.history.PrimitiveChange;
import org.eclipse.emf.edapt.spi.history.Release;
import org.eclipse.emf.edapt.spi.history.Remove;
import org.eclipse.emf.edapt.spi.history.Set;
import org.eclipse.emf.edapt.spi.history.ValueChange;

public class HistoryValidator
extends EObjectValidator {
    public static final HistoryValidator INSTANCE = new HistoryValidator();
    public static final String DIAGNOSTIC_SOURCE = "org.eclipse.emf.edapt.history";
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 0;
    protected static final int DIAGNOSTIC_CODE_COUNT = 0;

    protected EPackage getEPackage() {
        return HistoryPackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validateHistory((History)value, diagnostics, context);
            }
            case 1: {
                return this.validateRelease((Release)value, diagnostics, context);
            }
            case 2: {
                return this.validateChange((Change)value, diagnostics, context);
            }
            case 3: {
                return this.validatePrimitiveChange((PrimitiveChange)value, diagnostics, context);
            }
            case 4: {
                return this.validateNoChange((NoChange)value, diagnostics, context);
            }
            case 5: {
                return this.validateContentChange((ContentChange)value, diagnostics, context);
            }
            case 6: {
                return this.validateNonDelete((NonDelete)value, diagnostics, context);
            }
            case 7: {
                return this.validateCreate((Create)value, diagnostics, context);
            }
            case 8: {
                return this.validateMove((Move)value, diagnostics, context);
            }
            case 9: {
                return this.validateDelete((Delete)value, diagnostics, context);
            }
            case 10: {
                return this.validateValueChange((ValueChange)value, diagnostics, context);
            }
            case 11: {
                return this.validateSet((Set)value, diagnostics, context);
            }
            case 12: {
                return this.validateAdd((Add)value, diagnostics, context);
            }
            case 13: {
                return this.validateRemove((Remove)value, diagnostics, context);
            }
            case 14: {
                return this.validateCompositeChange((CompositeChange)value, diagnostics, context);
            }
            case 15: {
                return this.validateOperationChange((OperationChange)value, diagnostics, context);
            }
            case 16: {
                return this.validateOperationInstance((OperationInstance)value, diagnostics, context);
            }
            case 17: {
                return this.validateParameterInstance((ParameterInstance)value, diagnostics, context);
            }
            case 18: {
                return this.validateModelReference((ModelReference)value, diagnostics, context);
            }
            case 19: {
                return this.validateNamedElement((NamedElement)value, diagnostics, context);
            }
            case 20: {
                return this.validateMigrateableChange((MigrateableChange)value, diagnostics, context);
            }
            case 21: {
                return this.validateMigrationChange((MigrationChange)value, diagnostics, context);
            }
            case 22: {
                return this.validateInitializerChange((InitializerChange)value, diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateHistory(History history, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(history, diagnostics, context);
    }

    public boolean validateRelease(Release release, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(release, diagnostics, context);
    }

    public boolean validateChange(Change change, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(change, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(change, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(change, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(change, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(change, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(change, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(change, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(change, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(change, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateChange_Breaking(change, diagnostics, context);
        }
        return result;
    }

    public boolean validateChange_Breaking(Change change, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (change.isBreaking()) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(4, DIAGNOSTIC_SOURCE, 0, EcorePlugin.INSTANCE.getString("_UI_GenericConstraint_diagnostic", new Object[]{"Breaking", HistoryValidator.getObjectLabel((EObject)change, context)}), new Object[]{change}));
            }
            return false;
        }
        return true;
    }

    public boolean validatePrimitiveChange(PrimitiveChange primitiveChange, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(primitiveChange, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(primitiveChange, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(primitiveChange, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(primitiveChange, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(primitiveChange, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(primitiveChange, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(primitiveChange, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(primitiveChange, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(primitiveChange, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateChange_Breaking(primitiveChange, diagnostics, context);
        }
        return result;
    }

    public boolean validateNoChange(NoChange noChange, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(noChange, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(noChange, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(noChange, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(noChange, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(noChange, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(noChange, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(noChange, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(noChange, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(noChange, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateChange_Breaking(noChange, diagnostics, context);
        }
        return result;
    }

    public boolean validateContentChange(ContentChange contentChange, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(contentChange, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(contentChange, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(contentChange, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(contentChange, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(contentChange, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(contentChange, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(contentChange, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(contentChange, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(contentChange, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateChange_Breaking(contentChange, diagnostics, context);
        }
        return result;
    }

    public boolean validateNonDelete(NonDelete nonDelete, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(nonDelete, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(nonDelete, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(nonDelete, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(nonDelete, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(nonDelete, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(nonDelete, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(nonDelete, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(nonDelete, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(nonDelete, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateChange_Breaking(nonDelete, diagnostics, context);
        }
        return result;
    }

    public boolean validateCreate(Create create, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(create, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(create, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(create, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(create, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(create, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(create, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(create, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(create, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(create, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateChange_Breaking(create, diagnostics, context);
        }
        return result;
    }

    public boolean validateMove(Move move, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(move, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(move, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(move, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(move, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(move, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(move, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(move, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(move, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(move, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateChange_Breaking(move, diagnostics, context);
        }
        return result;
    }

    public boolean validateDelete(Delete delete, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(delete, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(delete, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(delete, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(delete, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(delete, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(delete, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(delete, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(delete, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(delete, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateChange_Breaking(delete, diagnostics, context);
        }
        return result;
    }

    public boolean validateValueChange(ValueChange valueChange, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(valueChange, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(valueChange, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(valueChange, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(valueChange, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(valueChange, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(valueChange, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(valueChange, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(valueChange, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(valueChange, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateChange_Breaking(valueChange, diagnostics, context);
        }
        return result;
    }

    public boolean validateSet(Set set, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(set, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(set, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(set, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(set, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(set, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(set, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(set, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(set, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(set, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateChange_Breaking(set, diagnostics, context);
        }
        return result;
    }

    public boolean validateAdd(Add add, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(add, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(add, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(add, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(add, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(add, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(add, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(add, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(add, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(add, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateChange_Breaking(add, diagnostics, context);
        }
        return result;
    }

    public boolean validateRemove(Remove remove, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(remove, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(remove, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(remove, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(remove, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(remove, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(remove, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(remove, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(remove, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(remove, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateChange_Breaking(remove, diagnostics, context);
        }
        return result;
    }

    public boolean validateCompositeChange(CompositeChange compositeChange, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(compositeChange, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(compositeChange, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(compositeChange, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(compositeChange, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(compositeChange, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(compositeChange, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(compositeChange, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(compositeChange, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(compositeChange, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateChange_Breaking(compositeChange, diagnostics, context);
        }
        return result;
    }

    public boolean validateOperationChange(OperationChange operationChange, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(operationChange, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(operationChange, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(operationChange, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(operationChange, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(operationChange, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(operationChange, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(operationChange, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(operationChange, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(operationChange, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateChange_Breaking(operationChange, diagnostics, context);
        }
        return result;
    }

    public boolean validateOperationInstance(OperationInstance operationInstance, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(operationInstance, diagnostics, context);
    }

    public boolean validateParameterInstance(ParameterInstance parameterInstance, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(parameterInstance, diagnostics, context);
    }

    public boolean validateModelReference(ModelReference modelReference, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(modelReference, diagnostics, context);
    }

    public boolean validateNamedElement(NamedElement namedElement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(namedElement, diagnostics, context);
    }

    public boolean validateMigrateableChange(MigrateableChange migrateableChange, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(migrateableChange, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(migrateableChange, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(migrateableChange, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(migrateableChange, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(migrateableChange, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(migrateableChange, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(migrateableChange, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(migrateableChange, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(migrateableChange, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateChange_Breaking(migrateableChange, diagnostics, context);
        }
        return result;
    }

    public boolean validateMigrationChange(MigrationChange migrationChange, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(migrationChange, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(migrationChange, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(migrationChange, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(migrationChange, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(migrationChange, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(migrationChange, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(migrationChange, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(migrationChange, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(migrationChange, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateChange_Breaking(migrationChange, diagnostics, context);
        }
        return result;
    }

    public boolean validateInitializerChange(InitializerChange initializerChange, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(initializerChange, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(initializerChange, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(initializerChange, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(initializerChange, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(initializerChange, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(initializerChange, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(initializerChange, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(initializerChange, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(initializerChange, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateChange_Breaking(initializerChange, diagnostics, context);
        }
        return result;
    }

    public ResourceLocator getResourceLocator() {
        return HistoryPlugin.INSTANCE;
    }
}

