/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.common;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emfforms.common.Property;

public class SimpleProperty<T>
implements Property<T> {
    private final String name;
    private final T defaultValue;
    private T value;
    private List<Property.ChangeListener<T>> listenerList = new ArrayList<Property.ChangeListener<T>>();
    private boolean disposed;

    private void checkDisposed() {
        if (this.disposed) {
            throw new IllegalStateException("Property is disposed");
        }
    }

    public SimpleProperty(String name, T defaultValue) {
        this.name = name;
        this.defaultValue = defaultValue;
        this.value = defaultValue;
    }

    @Override
    public void setValue(T value) {
        this.checkDisposed();
        T oldValue = this.value;
        this.value = value;
        for (Property.ChangeListener<T> listener : new ArrayList<Property.ChangeListener<T>>(this.listenerList)) {
            listener.valueChanged(this, oldValue, value);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public T getValue() {
        this.checkDisposed();
        return this.value;
    }

    @Override
    public T getDefault() {
        return this.defaultValue;
    }

    @Override
    public T resetToDefault() {
        this.setValue(this.defaultValue);
        return this.value;
    }

    @Override
    public void dispose() {
        if (this.listenerList != null) {
            this.listenerList.clear();
        }
        this.listenerList = null;
        this.disposed = true;
    }

    @Override
    public void addChangeListener(Property.ChangeListener<T> listener) {
        this.checkDisposed();
        this.listenerList.add(listener);
    }

    @Override
    public void removeChangeListener(Property.ChangeListener<T> listener) {
        this.checkDisposed();
        this.listenerList.remove(listener);
    }
}

