/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.ui.validation.e4.view;

import java.util.function.Consumer;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.services.EMenuService;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.emf.ecp.internal.ui.validation.ValidationTreeViewerFactory;
import org.eclipse.emf.ecp.ui.validation.ECPValidationResultService;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;

public class DiagnosticView {
    private static final String POPUPMENU_VALIDATION_ID = "org.eclipse.emf.ecp.e4.application.popupmenu.validation";
    @Inject
    private ECPValidationResultService service;
    @Inject
    private ValidationTreeViewerFactory factory;
    private ECPValidationResultService.ECPValidationResultServiceListener listener;
    private TreeViewer diagnosticTree;
    private Consumer<Object> diagnosticHandler = this::onDiagnostic;

    @PostConstruct
    public void create(Composite composite, EMenuService menuService, final ESelectionService selectionService) {
        this.diagnosticTree = this.factory.create(composite);
        menuService.registerContextMenu((Object)this.diagnosticTree.getTree(), POPUPMENU_VALIDATION_ID);
        this.diagnosticTree.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (IStructuredSelection.class.isInstance(selection)) {
                    IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                    if (structuredSelection != null && !structuredSelection.isEmpty()) {
                        if (structuredSelection.size() == 1) {
                            selectionService.setSelection(structuredSelection.getFirstElement());
                        } else {
                            selectionService.setSelection((Object)structuredSelection.toList());
                        }
                    } else {
                        selectionService.setSelection(null);
                    }
                }
            }
        });
        this.listener = diagnostic -> this.diagnosticHandler.accept(diagnostic);
        this.service.register(this.listener);
    }

    public TreeViewer getDiagnosticTree() {
        return this.diagnosticTree;
    }

    public void expandAll() {
        this.diagnosticTree.expandAll();
    }

    public void collapseAll() {
        this.diagnosticTree.collapseAll();
    }

    @Focus
    public void setFocus() {
        this.diagnosticTree.getTree().setFocus();
    }

    @PreDestroy
    public void preDestroy() {
        this.service.deregister(this.listener);
    }

    public void setOnDiagnostic(Consumer<Object> diagnosticHandler) {
        this.diagnosticHandler = diagnosticHandler != null ? diagnosticHandler : this::onDiagnostic;
    }

    protected final void onDiagnostic(Object diagnostic) {
        this.diagnosticTree.setInput(diagnostic);
        this.diagnosticTree.expandAll();
    }
}

