/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.edapt;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecp.spi.view.migrator.NameSpaceHandler;
import org.eclipse.emf.ecp.spi.view.migrator.SAXUtil;
import org.eclipse.emf.ecp.spi.view.migrator.string.StringViewModelMigrator;
import org.eclipse.emf.ecp.spi.view.migrator.string.StringViewModelMigratorUtil;
import org.eclipse.emf.ecp.view.edapt.CustomMigrationClassLoader;
import org.eclipse.emf.ecp.view.edapt.PackageDependencyGraph;
import org.eclipse.emf.ecp.view.migrator.ViewModelMigrationException;
import org.eclipse.emf.ecp.view.migrator.ViewModelMigrator;
import org.eclipse.emf.ecp.view.spi.model.util.VViewResourceFactoryImpl;
import org.eclipse.emf.edapt.common.IResourceSetFactory;
import org.eclipse.emf.edapt.history.recorder.HistoryGenerator;
import org.eclipse.emf.edapt.internal.common.LoggingUtils;
import org.eclipse.emf.edapt.internal.common.URIUtils;
import org.eclipse.emf.edapt.internal.migration.execution.IClassLoader;
import org.eclipse.emf.edapt.internal.migration.execution.internal.BundleClassLoader;
import org.eclipse.emf.edapt.migration.MigrationException;
import org.eclipse.emf.edapt.migration.execution.Migrator;
import org.eclipse.emf.edapt.migration.execution.MigratorRegistry;
import org.eclipse.emf.edapt.spi.history.Change;
import org.eclipse.emf.edapt.spi.history.History;
import org.eclipse.emf.edapt.spi.history.HistoryFactory;
import org.eclipse.emf.edapt.spi.history.MigrationChange;
import org.eclipse.emf.edapt.spi.history.Release;
import org.eclipse.emf.edapt.spi.migration.MigrationPlugin;
import org.osgi.framework.Bundle;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class EdaptViewModelMigrator
implements ViewModelMigrator,
StringViewModelMigrator {
    private static final String ECORE_NS_URI = "http://www.eclipse.org/emf/2002/Ecore";
    private static final Comparator<String> RELEASE_COMPERATOR = new Comparator<String>(){

        @Override
        public int compare(String left, String right) {
            return Integer.valueOf(left).compareTo(Integer.valueOf(right));
        }
    };

    public boolean checkMigration(String serializedViewModel) {
        return this.checkMigration(StringViewModelMigratorUtil.getNamespaceURIs((String)serializedViewModel));
    }

    public boolean checkMigration(URI resourceURI) {
        return this.checkMigration(this.getNamespaceURIs(resourceURI));
    }

    private boolean checkMigration(List<String> nsUris) {
        boolean allReleasesAreLatest = true;
        ArrayList<Release> releases = new ArrayList<Release>();
        for (String nsUri : nsUris) {
            Migrator migrator = MigratorRegistry.getInstance().getMigrator(nsUri);
            if (migrator == null) continue;
            Release nsRelease = this.getReleaseFromMigrator(nsUri, migrator);
            releases.add(nsRelease);
            if (migrator.getLatestRelease().equals(nsRelease)) continue;
            allReleasesAreLatest = false;
            break;
        }
        return allReleasesAreLatest;
    }

    public String performMigration(String serializedViewModel) throws ViewModelMigrationException {
        PrintWriter printWriter = null;
        File tempViewModelFile = null;
        Scanner scanner = null;
        try {
            tempViewModelFile = File.createTempFile("view", ".view");
            tempViewModelFile.deleteOnExit();
            printWriter = new PrintWriter(tempViewModelFile);
            printWriter.print(serializedViewModel);
            printWriter.flush();
            printWriter.close();
            this.performMigration(URI.createFileURI((String)tempViewModelFile.getAbsolutePath()));
            scanner = new Scanner(tempViewModelFile, "UTF-8");
            String string = scanner.useDelimiter("\\A").next();
            return string;
        }
        catch (IOException ex) {
            throw new ViewModelMigrationException((Throwable)ex);
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
            if (scanner != null) {
                scanner.close();
            }
            if (tempViewModelFile != null) {
                tempViewModelFile.delete();
            }
        }
    }

    public void performMigration(URI resourceURI) throws ViewModelMigrationException {
        History history = HistoryFactory.eINSTANCE.createHistory();
        Release sourceRelease = HistoryFactory.eINSTANCE.createRelease();
        ArrayList<Release> targetReleases = new ArrayList<Release>();
        NSURIMapping domainMapping = this.addChangesForDomainModel(resourceURI, sourceRelease);
        List<String> nsUris = this.getNamespaceURIsWithHistory(resourceURI, domainMapping);
        this.orderHistoriesAndCombineChanges(sourceRelease, targetReleases, nsUris);
        history.getReleases().add((Object)sourceRelease);
        history.getReleases().addAll(targetReleases);
        history.getReleases().add((Object)HistoryFactory.eINSTANCE.createRelease());
        try {
            try {
                URI uri = this.saveHistoryFile(history);
                Migrator migrator = new Migrator(uri, (IClassLoader)new CustomMigrationClassLoader());
                migrator.setResourceSetFactory(new IResourceSetFactory(){

                    public ResourceSet createResourceSet() {
                        ResourceSetImpl resourceSet = new ResourceSetImpl();
                        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new VViewResourceFactoryImpl());
                        return resourceSet;
                    }
                });
                Release release = migrator.getRelease(0);
                migrator.migrateAndSave(Collections.singletonList(resourceURI), release, null, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (IOException ex) {
                throw new ViewModelMigrationException((Throwable)ex);
            }
            catch (MigrationException ex) {
                throw new ViewModelMigrationException((Throwable)ex);
            }
        }
        finally {
            this.reregisterExtensionMigrators();
        }
    }

    private URI saveHistoryFile(History history) throws IOException {
        File historyFile = File.createTempFile("EMFFormsMigration", ".history");
        historyFile.deleteOnExit();
        URI uri = URI.createFileURI((String)historyFile.getAbsolutePath());
        Resource resource = new ResourceSetImpl().createResource(uri);
        resource.getContents().add((Object)history);
        resource.save(Collections.singletonMap("ENCODING", "UTF-8"));
        return uri;
    }

    private void orderHistoriesAndCombineChanges(Release sourceRelease, List<Release> targetReleases, List<String> nsUris) {
        PackageDependencyGraph viewModelPackageGraph = new PackageDependencyGraph();
        LinkedHashMap<String, Migrator> nsURIToMigratorMap = new LinkedHashMap<String, Migrator>();
        LinkedHashMap<String, String> latestToCurrentNSURIMap = new LinkedHashMap<String, String>();
        block0: for (String nsUri : nsUris) {
            Migrator migrator = MigratorRegistry.getInstance().getMigrator(nsUri);
            nsURIToMigratorMap.put(nsUri, migrator);
            for (String migratorNSURI : migrator.getNsURIs()) {
                if (!EPackage.Registry.INSTANCE.containsKey((Object)migratorNSURI)) continue;
                viewModelPackageGraph.addPackage(migratorNSURI);
                if (latestToCurrentNSURIMap.containsKey(migratorNSURI)) {
                    String string = (String)latestToCurrentNSURIMap.get(migratorNSURI);
                    String olderNSURI = string.compareTo(nsUri) < 0 ? string : nsUri;
                    latestToCurrentNSURIMap.put(migratorNSURI, olderNSURI);
                    continue block0;
                }
                latestToCurrentNSURIMap.put(migratorNSURI, nsUri);
                continue block0;
            }
        }
        LinkedHashMap<String, List<Change>> sourceReleaseNameToChangesMap = new LinkedHashMap<String, List<Change>>();
        LinkedHashMap<String, List<Change>> targetReleaseNameToChangesMap = new LinkedHashMap<String, List<Change>>();
        Iterator<Set<String>> viewModelPackageIterator = viewModelPackageGraph.getIerator();
        while (viewModelPackageIterator.hasNext()) {
            Set<String> latestURIs = viewModelPackageIterator.next();
            for (String latestURI : latestURIs) {
                if (!latestToCurrentNSURIMap.keySet().contains(latestURI)) continue;
                String nsUri = (String)latestToCurrentNSURIMap.get(latestURI);
                Migrator migrator = (Migrator)nsURIToMigratorMap.get(nsUri);
                Release nsRelease = this.getReleaseFromMigrator(nsUri, migrator);
                int sourceIndex = nsRelease.getNumber();
                int i = 0;
                while (i <= sourceIndex) {
                    Release currentRelease = migrator.getRelease(i);
                    if (!sourceReleaseNameToChangesMap.containsKey(currentRelease.getLabel())) {
                        sourceReleaseNameToChangesMap.put(currentRelease.getLabel(), new ArrayList());
                    }
                    ((List)sourceReleaseNameToChangesMap.get(currentRelease.getLabel())).addAll(currentRelease.getChanges());
                    ++i;
                }
                int targetIndex = migrator.getLatestRelease().getNumber();
                if (targetIndex <= sourceIndex) continue;
                int i2 = sourceIndex + 1;
                while (i2 <= targetIndex) {
                    Release currentRelease = migrator.getRelease(i2);
                    if (!targetReleaseNameToChangesMap.containsKey(currentRelease.getLabel())) {
                        targetReleaseNameToChangesMap.put(currentRelease.getLabel(), new ArrayList());
                    }
                    ((List)targetReleaseNameToChangesMap.get(currentRelease.getLabel())).addAll(currentRelease.getChanges());
                    ++i2;
                }
            }
        }
        this.fillReleases(sourceRelease, targetReleases, sourceReleaseNameToChangesMap, targetReleaseNameToChangesMap);
    }

    private void fillReleases(Release sourceRelease, List<Release> targetReleases, Map<String, List<Change>> sourceReleaseNameToChangesMap, Map<String, List<Change>> targetReleaseNameToChangesMap) {
        TreeSet<String> sourceReleaseNames = new TreeSet<String>(RELEASE_COMPERATOR);
        sourceReleaseNames.addAll(sourceReleaseNameToChangesMap.keySet());
        TreeSet<String> targetReleaseNames = new TreeSet<String>(RELEASE_COMPERATOR);
        targetReleaseNames.addAll(targetReleaseNameToChangesMap.keySet());
        for (String release : sourceReleaseNames) {
            List<Change> list = sourceReleaseNameToChangesMap.get(release);
            sourceRelease.getChanges().addAll(list);
            sourceRelease.setDate(new Date());
            sourceRelease.setLabel("source");
        }
        for (String release : targetReleaseNames) {
            Release targetRelease = HistoryFactory.eINSTANCE.createRelease();
            targetRelease.setDate(new Date());
            targetRelease.setLabel(release);
            targetReleases.add(targetRelease);
            List<Change> list = targetReleaseNameToChangesMap.get(release);
            targetRelease.getChanges().addAll(list);
            ArrayList<Integer> indexes = new ArrayList<Integer>();
            int i = 0;
            while (i < targetRelease.getChanges().size()) {
                Change currentChange = (Change)targetRelease.getChanges().get(i);
                if (MigrationChange.class.isInstance(currentChange)) {
                    indexes.add(i);
                }
                ++i;
            }
            int lastIndex = targetRelease.getChanges().size() - 1;
            int i2 = indexes.size() - 1;
            while (i2 > -1) {
                Change changeToMove = (Change)targetRelease.getChanges().get(((Integer)indexes.get(i2)).intValue());
                targetRelease.getChanges().move(lastIndex, (Object)changeToMove);
                --i2;
            }
        }
    }

    private List<String> getNamespaceURIsWithHistory(URI resourceURI, NSURIMapping domainMapping) {
        List<String> nsUris = this.getNamespaceURIs(resourceURI);
        for (String nsURI : domainMapping.getNsURIsWithGeneratedHistory()) {
            nsUris.remove(nsURI);
        }
        nsUris.addAll(domainMapping.getNsURIsWithHistory());
        return nsUris;
    }

    private NSURIMapping addChangesForDomainModel(URI resourceURI, Release release) {
        LinkedHashSet<String> nsURIsWithHistory = new LinkedHashSet<String>();
        LinkedHashSet<String> nsURIsWithGeneratedHistory = new LinkedHashSet<String>();
        PackageDependencyGraph domainModelPackageGraph = new PackageDependencyGraph();
        domainModelPackageGraph.addPackage(ECORE_NS_URI);
        Set<String> rootPackageURIs = this.getRootPackageURI(resourceURI);
        for (String rootPackageNsUri : rootPackageURIs) {
            Migrator rootMigrator = MigratorRegistry.getInstance().getMigrator(rootPackageNsUri);
            if (rootMigrator != null) {
                for (String migratorNSURI : rootMigrator.getNsURIs()) {
                    if (!EPackage.Registry.INSTANCE.containsKey((Object)migratorNSURI)) continue;
                    nsURIsWithHistory.add(rootPackageNsUri);
                    rootPackageNsUri = migratorNSURI;
                    break;
                }
            }
            domainModelPackageGraph.addPackage(rootPackageNsUri);
        }
        ArrayList<EPackage> rootPackages = new ArrayList<EPackage>();
        Iterator<Set<String>> packageIterator = domainModelPackageGraph.getIerator();
        while (packageIterator.hasNext()) {
            Set<String> nsURIs = packageIterator.next();
            for (String nsURI : nsURIs) {
                if (MigratorRegistry.getInstance().getMigrator(nsURI) == null) {
                    EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(nsURI);
                    rootPackages.add(ePackage);
                    nsURIsWithGeneratedHistory.add(nsURI);
                    continue;
                }
                nsURIsWithHistory.add(nsURI);
            }
        }
        HistoryGenerator rootGenerator = new HistoryGenerator(rootPackages);
        EList rootChanges = rootGenerator.generate().getFirstRelease().getChanges();
        release.getChanges().addAll((Collection)rootChanges);
        return new NSURIMapping(nsURIsWithHistory, nsURIsWithGeneratedHistory);
    }

    private Release getReleaseFromMigrator(String nsUri, Migrator migrator) {
        Map releaseMap = migrator.getReleaseMap();
        Set nsReleases = (Set)releaseMap.get(nsUri);
        return nsReleases.stream().sorted(this::compareReleases).findFirst().orElse(null);
    }

    private int compareReleases(Release r1, Release r2) {
        return r2.getNumber() - r1.getNumber();
    }

    private List<String> getNamespaceURIs(URI resourceURI) {
        File file = URIUtils.getJavaFile((URI)resourceURI);
        NameSpaceHandler handler = new NameSpaceHandler();
        EdaptViewModelMigrator.executeContentHandler(file, (DefaultHandler)handler);
        return handler.getNsURIs();
    }

    private Set<String> getRootPackageURI(URI resourceURI) {
        File file = URIUtils.getJavaFile((URI)resourceURI);
        RootPackageHandler handler = new RootPackageHandler();
        EdaptViewModelMigrator.executeContentHandler(file, handler);
        if (handler.foundRootEClass()) {
            return Collections.singleton(handler.getRootPackageURI());
        }
        RootPackageCalculationHandler calcHandler = new RootPackageCalculationHandler();
        EdaptViewModelMigrator.executeContentHandler(file, calcHandler);
        return calcHandler.getUsedPackages();
    }

    private static void executeContentHandler(File file, DefaultHandler contentHandler) {
        try {
            SAXUtil.executeContentHandler((Reader)new FileReader(file), (ContentHandler)contentHandler);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    private void reregisterExtensionMigrators() {
        IConfigurationElement[] configurationElements;
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = configurationElements = extensionRegistry.getConfigurationElementsFor("org.eclipse.emf.edapt.migrators");
        int n = configurationElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configurationElement = iConfigurationElementArray[n2];
            this.registerExtensionMigrator(configurationElement);
            ++n2;
        }
    }

    private void registerExtensionMigrator(IConfigurationElement configurationElement) {
        String migrationPath = configurationElement.getAttribute("path");
        IContributor contributor = configurationElement.getContributor();
        String bundleName = contributor.getName();
        Bundle bundle = Platform.getBundle((String)bundleName);
        URI migratorURI = URI.createPlatformPluginURI((String)("/" + bundleName + "/" + migrationPath), (boolean)true);
        try {
            MigratorRegistry.getInstance().registerMigrator(migratorURI, (IClassLoader)new BundleClassLoader(bundle));
        }
        catch (MigrationException e) {
            LoggingUtils.logError((Plugin)MigrationPlugin.getPlugin(), (Throwable)e);
        }
    }

    private static class NSURIMapping {
        private final Set<String> nsURIsWithHistory;
        private final Set<String> nsURIsWithGeneratedHistory;

        NSURIMapping(Set<String> nsURIsWithHistory, Set<String> nsURIsWithGeneratedHistory) {
            this.nsURIsWithHistory = nsURIsWithHistory;
            this.nsURIsWithGeneratedHistory = nsURIsWithGeneratedHistory;
        }

        public Set<String> getNsURIsWithHistory() {
            return this.nsURIsWithHistory;
        }

        public Set<String> getNsURIsWithGeneratedHistory() {
            return this.nsURIsWithGeneratedHistory;
        }
    }

    private static class RootPackageCalculationHandler
    extends DefaultHandler {
        private final Set<String> packages = new LinkedHashSet<String>();

        private RootPackageCalculationHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            super.startElement(uri, localName, qName, attributes);
            String href = attributes.getValue("href");
            String type = attributes.getValue("xsi:type");
            if (href == null || type == null) {
                return;
            }
            if (!type.endsWith("EAttribute") && !type.endsWith("EReference")) {
                return;
            }
            this.packages.add(href.split("#")[0]);
        }

        public Set<String> getUsedPackages() {
            return this.packages;
        }
    }

    private static class RootPackageHandler
    extends DefaultHandler {
        private String rootPackageURI = "";
        private boolean rootEClassFound;

        private RootPackageHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            super.startElement(uri, localName, qName, attributes);
            if (localName.equals("rootEClass")) {
                String rawUri = attributes.getValue("href");
                this.rootPackageURI = rawUri.split("#")[0];
                this.rootEClassFound = true;
                throw new SAXException();
            }
        }

        public boolean foundRootEClass() {
            return this.rootEClassFound;
        }

        public String getRootPackageURI() {
            return this.rootPackageURI;
        }
    }
}

