/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.changebroker.emfstore.internal;

import java.util.Collection;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecp.changebroker.spi.AbstractNotificationProvider;
import org.eclipse.emf.ecp.core.ECPProjectManager;
import org.eclipse.emf.ecp.core.ECPProvider;
import org.eclipse.emf.ecp.core.util.ECPElement;
import org.eclipse.emf.ecp.core.util.ECPUtil;
import org.eclipse.emf.ecp.core.util.observer.ECPObserver;
import org.eclipse.emf.ecp.core.util.observer.ECPProvidersChangedObserver;
import org.eclipse.emf.ecp.emfstore.core.internal.EMFStoreProvider;
import org.eclipse.emf.ecp.emfstore.core.internal.EMFStoreProviderChangeListener;

public class EMFStoreNotificationProvider
extends AbstractNotificationProvider {
    private static final String EMFSTORE_PROVIDER = "org.eclipse.emf.ecp.emfstore.provider";

    public void bindManager(ECPProjectManager manager) {
        manager.getProjects();
        if (EMFStoreProvider.INSTANCE == null) {
            ECPUtil.getECPObserverBus().register((ECPObserver)new ECPProvidersChangedObserver(){

                public void providersChanged(Collection<ECPProvider> oldProviders, Collection<ECPProvider> newProviders) {
                    for (ECPProvider ecpProvider : newProviders) {
                        if (!EMFStoreNotificationProvider.EMFSTORE_PROVIDER.equals(ecpProvider.getName())) continue;
                        ECPUtil.getResolvedElement((ECPElement)ecpProvider);
                        EMFStoreNotificationProvider.this.addObserver();
                        ECPUtil.getECPObserverBus().unregister((ECPObserver)this);
                    }
                }
            });
        } else {
            this.addObserver();
        }
    }

    private void addObserver() {
        EMFStoreProvider.INSTANCE.registerChangeListener(new EMFStoreProviderChangeListener(){

            public void onNewNotification(Notification notification) {
                EMFStoreNotificationProvider.this.notifyAllReceivers(notification);
            }
        });
    }
}

