/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.internal.core.services.databinding;

import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.property.list.IListProperty;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.DomainModelReferenceConverter;
import org.eclipse.emfforms.spi.core.services.databinding.EMFFormsDatabinding;

public class EMFFormsDatabindingImpl
implements EMFFormsDatabinding {
    private final Set<DomainModelReferenceConverter> referenceConverters = new LinkedHashSet<DomainModelReferenceConverter>();

    public IObservableValue getObservableValue(VDomainModelReference domainModelReference, EObject object) throws DatabindingFailedException {
        if (domainModelReference == null) {
            throw new IllegalArgumentException("The given VDomainModelReference must not be null.");
        }
        if (object == null) {
            throw new IllegalArgumentException("The given EObject must not be null.");
        }
        IValueProperty valueProperty = this.getValueProperty(domainModelReference, object);
        return valueProperty.observe((Object)object);
    }

    public IValueProperty getValueProperty(VDomainModelReference domainModelReference, EObject object) throws DatabindingFailedException {
        DomainModelReferenceConverter bestConverter = this.getBestDomainModelReferenceConverter(domainModelReference);
        if (bestConverter != null) {
            return bestConverter.convertToValueProperty(domainModelReference, object);
        }
        throw new DatabindingFailedException(String.format("No applicable DomainModelReferenceConverter could be found for %1$s .", domainModelReference.eClass().getName()));
    }

    protected void addDomainModelReferenceConverter(DomainModelReferenceConverter converter) {
        this.referenceConverters.add(converter);
    }

    protected void removeDomainModelReferenceConverter(DomainModelReferenceConverter converter) {
        this.referenceConverters.remove(converter);
    }

    public IObservableList getObservableList(VDomainModelReference domainModelReference, EObject object) throws DatabindingFailedException {
        if (domainModelReference == null) {
            throw new IllegalArgumentException("The given VDomainModelReference must not be null.");
        }
        if (object == null) {
            throw new IllegalArgumentException("The given EObject must not be null.");
        }
        IListProperty listProperty = this.getListProperty(domainModelReference, object);
        return listProperty.observe((Object)object);
    }

    public IListProperty getListProperty(VDomainModelReference domainModelReference, EObject object) throws DatabindingFailedException {
        DomainModelReferenceConverter bestConverter = this.getBestDomainModelReferenceConverter(domainModelReference);
        if (bestConverter != null) {
            return bestConverter.convertToListProperty(domainModelReference, object);
        }
        throw new DatabindingFailedException("No applicable DomainModelReferenceConverter could be found.");
    }

    private DomainModelReferenceConverter getBestDomainModelReferenceConverter(VDomainModelReference domainModelReference) {
        if (domainModelReference == null) {
            throw new IllegalArgumentException("The given VDomainModelReference must not be null.");
        }
        double highestPriority = Double.NEGATIVE_INFINITY;
        DomainModelReferenceConverter bestConverter = null;
        for (DomainModelReferenceConverter converter : this.referenceConverters) {
            double priority = converter.isApplicable(domainModelReference);
            if (!(priority > highestPriority)) continue;
            highestPriority = priority;
            bestConverter = converter;
        }
        return bestConverter;
    }
}

