/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.history.instantiation;

import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.edapt.common.LoggingUtils;
import org.eclipse.emf.edapt.common.MetamodelExtent;
import org.eclipse.emf.edapt.declaration.OperationImplementation;
import org.eclipse.emf.edapt.internal.migration.execution.OperationInstanceConverter;
import org.eclipse.emf.edapt.migration.MigrationException;
import org.eclipse.emf.edapt.spi.history.OperationInstance;
import org.eclipse.emf.edapt.spi.history.provider.HistoryEditPlugin;
import org.eclipse.emf.edapt.spi.migration.Metamodel;
import org.eclipse.emf.edapt.spi.migration.Repository;

public class OperationInterpreter {
    private final OperationInstance operationInstance;
    private final MetamodelExtent extent;

    public OperationInterpreter(OperationInstance operationInstance, MetamodelExtent extent) {
        this.operationInstance = operationInstance;
        this.extent = extent;
    }

    public void execute() {
        Repository repository = OperationInstanceConverter.createEmptyRepository((MetamodelExtent)this.extent);
        OperationImplementation operation = OperationInstanceConverter.convert((OperationInstance)this.operationInstance, (Metamodel)repository.getMetamodel());
        try {
            operation.checkAndExecute(repository.getMetamodel(), repository.getModel());
        }
        catch (MigrationException e) {
            LoggingUtils.logError((Plugin)HistoryEditPlugin.getPlugin(), (Throwable)e);
        }
    }
}

