/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.history.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edapt.spi.history.Change;
import org.eclipse.emf.edapt.spi.history.CompositeChange;
import org.eclipse.emf.edapt.spi.history.ContentChange;
import org.eclipse.emf.edapt.spi.history.Create;
import org.eclipse.emf.edapt.spi.history.Delete;
import org.eclipse.emf.edapt.spi.history.InitializerChange;
import org.eclipse.emf.edapt.spi.history.MigrateableChange;
import org.eclipse.emf.edapt.spi.history.MigrationChange;
import org.eclipse.emf.edapt.spi.history.Move;
import org.eclipse.emf.edapt.spi.history.NonDelete;
import org.eclipse.emf.edapt.spi.history.PrimitiveChange;
import org.eclipse.emf.edapt.spi.history.Set;
import org.eclipse.emf.edapt.spi.history.ValueChange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DependencyChecker {
    private DependencyChecker() {
    }

    public static boolean depends(List<Change> sourceChanges, List<Change> targetChanges) {
        for (Change sourceChange : sourceChanges) {
            if (!DependencyChecker.depends(sourceChange, targetChanges)) continue;
            return true;
        }
        return false;
    }

    public static boolean depends(Change sourceChange, List<Change> targetChanges) {
        for (Change targetChange : targetChanges) {
            if (!DependencyChecker.depends(sourceChange, targetChange)) continue;
            return true;
        }
        return false;
    }

    public static boolean depends(Change source, Change target) {
        List<PrimitiveChange> sourceChanges = DependencyChecker.getPrimitiveChanges(source);
        List<PrimitiveChange> targetChanges = DependencyChecker.getPrimitiveChanges(target);
        for (PrimitiveChange sourceChange : sourceChanges) {
            for (PrimitiveChange targetChange : targetChanges) {
                if (!DependencyChecker.depends(sourceChange, targetChange)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean depends(PrimitiveChange source, PrimitiveChange target) {
        return DependencyChecker.requires(source, target) || DependencyChecker.conflicts(source, target);
    }

    private static boolean requires(PrimitiveChange source, PrimitiveChange target) {
        if (source instanceof Delete) {
            return DependencyChecker.requires((Delete)source, target);
        }
        if (target instanceof Create) {
            return DependencyChecker.requires(source, (Create)target);
        }
        return false;
    }

    private static boolean requires(PrimitiveChange source, Create target) {
        java.util.Set<EObject> elements = DependencyChecker.getElements(source);
        for (EObject element : elements) {
            if (element != target.getElement()) continue;
            return true;
        }
        return false;
    }

    private static boolean requires(Delete source, PrimitiveChange target) {
        java.util.Set<EObject> elements = DependencyChecker.getElements(target);
        for (EObject element : elements) {
            if (!DependencyChecker.isDeleted(source, element)) continue;
            return true;
        }
        return false;
    }

    private static boolean conflicts(PrimitiveChange source, PrimitiveChange target) {
        if (source instanceof ValueChange && target instanceof ValueChange) {
            return DependencyChecker.conflicts((ValueChange)source, (ValueChange)target);
        }
        if (source instanceof Move && target instanceof Move) {
            return DependencyChecker.conflicts((Move)source, (Move)target);
        }
        return false;
    }

    private static boolean conflicts(ValueChange source, ValueChange target) {
        if (source.getElement() == target.getElement() && source.getFeature() == target.getFeature()) {
            EStructuralFeature feature = source.getFeature();
            if (feature.isMany()) {
                if (source.getValue() == target.getValue()) {
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    private static boolean conflicts(Move source, Move target) {
        return source.getElement() == target.getElement() && source.getReference() == target.getReference();
    }

    private static List<PrimitiveChange> getPrimitiveChanges(Change change) {
        ArrayList<PrimitiveChange> changes = new ArrayList<PrimitiveChange>();
        if (change instanceof PrimitiveChange) {
            changes.add((PrimitiveChange)change);
            if (change instanceof InitializerChange) {
                InitializerChange initializerChange = (InitializerChange)change;
                changes.addAll((Collection<PrimitiveChange>)initializerChange.getChanges());
            }
        } else if (change instanceof CompositeChange) {
            CompositeChange compositeChange = (CompositeChange)change;
            changes.addAll((Collection<PrimitiveChange>)compositeChange.getChanges());
        } else if (change instanceof MigrationChange) {
            MigrationChange migrationChange = (MigrationChange)change;
            for (MigrateableChange migrateableChange : migrationChange.getChanges()) {
                changes.addAll(DependencyChecker.getPrimitiveChanges(migrateableChange));
            }
        }
        return changes;
    }

    private static boolean isDeleted(Delete delete, EObject element) {
        if (delete.getElement() == element) {
            return true;
        }
        TreeIterator i = delete.getElement().eAllContents();
        while (i.hasNext()) {
            if (i.next() != element) continue;
            return true;
        }
        return false;
    }

    private static java.util.Set<EObject> getElements(PrimitiveChange change) {
        HashSet<EObject> elements;
        block9: {
            block8: {
                Set set;
                elements = new HashSet<EObject>();
                if (!(change instanceof ValueChange)) break block8;
                ValueChange valueChange = (ValueChange)change;
                elements.add(valueChange.getElement());
                if (!(valueChange.getFeature() instanceof EReference)) break block9;
                if (valueChange.getReferenceValue() != null) {
                    elements.add(valueChange.getReferenceValue());
                }
                if (!(valueChange instanceof Set) || (set = (Set)valueChange).getOldReferenceValue() == null) break block9;
                elements.add(set.getOldReferenceValue());
                break block9;
            }
            if (change instanceof ContentChange) {
                ContentChange contentChange = (ContentChange)change;
                if (contentChange.getTarget() != null) {
                    elements.add(contentChange.getTarget());
                }
                if (contentChange instanceof NonDelete) {
                    NonDelete nonDelete = (NonDelete)contentChange;
                    elements.add(nonDelete.getElement());
                    if (nonDelete instanceof Move) {
                        Move move = (Move)nonDelete;
                        elements.add(move.getSource());
                    }
                } else if (contentChange instanceof Delete) {
                    Delete delete = (Delete)contentChange;
                    elements.add(delete.getElement());
                    TreeIterator i = delete.getElement().eAllContents();
                    while (i.hasNext()) {
                        elements.add((EObject)i.next());
                    }
                }
            }
        }
        return elements;
    }
}

