/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.data.core.cdi;

import ee.jakarta.tck.data.core.cdi.AddressBook;
import ee.jakarta.tck.data.core.cdi.Directory;
import ee.jakarta.tck.data.framework.junit.anno.AnyEntity;
import ee.jakarta.tck.data.framework.junit.anno.Assertion;
import ee.jakarta.tck.data.framework.junit.anno.CDIRequired;
import ee.jakarta.tck.data.framework.junit.anno.Core;
import jakarta.enterprise.inject.spi.CDI;
import java.lang.annotation.Annotation;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Assertions;

@Core
@AnyEntity
@CDIRequired
public class CDITests {
    @Deployment
    public static WebArchive createDeployment() {
        return (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addPackage(CDITests.class.getPackage());
    }

    @Assertion(id="640", strategy="Verifies that another Jakarta Data Provider does not attempt to implement the Dictonary repository based on provider attribute.")
    public void testDataRepositoryHonorsProviderAttribute() {
        Assertions.assertTrue((boolean)CDI.current().select(Directory.class, new Annotation[0]).isUnsatisfied());
    }

    @Assertion(id="640", strategy="Verifies that another Jakarta Data Provider does not attempt to implement the Address repository based on the EntityDefining annotation.")
    public void testDataRepositoryHonorsEntityDefiningAnnotation() {
        Assertions.assertTrue((boolean)CDI.current().select(AddressBook.class, new Annotation[0]).isUnsatisfied());
    }
}

