/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.el.spec.mapper;

import com.sun.ts.tests.el.common.elcontext.FuncMapperELContext;
import com.sun.ts.tests.el.common.elcontext.VarMapperELContext;
import com.sun.ts.tests.el.common.functionmapper.TCKFunctionMapper;
import com.sun.ts.tests.el.common.util.ELTestUtil;
import com.sun.ts.tests.el.common.util.ExprEval;
import jakarta.el.ELContext;
import jakarta.el.ELException;
import jakarta.el.ExpressionFactory;
import jakarta.el.ValueExpression;
import jakarta.el.VariableMapper;
import java.util.Properties;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

public class ELClientIT {
    private static final System.Logger logger = System.getLogger(ELClientIT.class.getName());
    Properties testProps = System.getProperties();

    @AfterEach
    public void cleanup() throws Exception {
        logger.log(System.Logger.Level.INFO, "Cleanup method called");
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    public void ELFunctionBindingTest() throws Exception {
        block7: {
            Class<Integer> expectedClass = Integer.class;
            Integer expectedValue = 10;
            ExpressionFactory expFactory = ExpressionFactory.newInstance();
            FuncMapperELContext context = new FuncMapperELContext();
            ValueExpression vexp1 = expFactory.createValueExpression((ELContext)context, "${Int:val(10)}", Object.class);
            ValueExpression vexp2 = expFactory.createValueExpression((ELContext)context, "${Int:val(\"string\")}", Object.class);
            Object initialResult = vexp1.getValue((ELContext)context);
            if (!ExprEval.compareClass(initialResult, expectedClass)) {
                throw new Exception("Wrong class for initial Expression evaluation");
            }
            if (!ExprEval.compareValue(initialResult, expectedValue)) {
                throw new Exception("Wrong value for initial Expression evaluation");
            }
            TCKFunctionMapper mapper = (TCKFunctionMapper)context.getFunctionMapper();
            mapper.update();
            Object finalResult = vexp1.getValue((ELContext)context);
            if (!ExprEval.compareClass(finalResult, expectedClass)) {
                throw new Exception("Wrong class for final Expression evaluation");
            }
            if (!ExprEval.compareValue(finalResult, expectedValue)) {
                throw new Exception("Wrong value for final Expression evaluation");
            }
            try {
                vexp2.getValue((ELContext)context);
            }
            catch (Throwable t) {
                if (!(t instanceof ELException)) {
                    logger.log(System.Logger.Level.ERROR, "Expected ELException to be thrown");
                    logger.log(System.Logger.Level.ERROR, "instead threw " + t.toString());
                    ELTestUtil.printStackTrace(t);
                    throw new Exception("ELException not thrown");
                }
                Throwable cause = t.getCause();
                if (cause instanceof NumberFormatException) break block7;
                logger.log(System.Logger.Level.ERROR, "Expected cause to be NumberFormatException");
                logger.log(System.Logger.Level.ERROR, "instead cause is " + cause.toString());
                ELTestUtil.printStackTrace(cause);
                throw new Exception("NumberFormatException not cause");
            }
        }
    }

    @Test
    public void ELVariableBindingTest() throws Exception {
        Class<Double> expectedClass = Double.class;
        Double expectedValue = 10.0;
        ExpressionFactory expFactory = ExpressionFactory.newInstance();
        VarMapperELContext context = new VarMapperELContext(this.testProps);
        VariableMapper varMapper = context.getVariableMapper();
        ValueExpression vexp1 = expFactory.createValueExpression((ELContext)context, "#{1e1}", Object.class);
        varMapper.setVariable("ten", vexp1);
        ValueExpression vexp2 = varMapper.resolveVariable("ten");
        Object initialResult = vexp2.getValue((ELContext)context);
        if (!ExprEval.compareClass(initialResult, expectedClass)) {
            throw new Exception("Wrong class for initial Expression evaluation");
        }
        if (!ExprEval.compareValue(initialResult, expectedValue)) {
            throw new Exception("Wrong value for initial Expression evaluation");
        }
        varMapper.setVariable("ten", null);
        Object finalResult = vexp2.getValue((ELContext)context);
        if (!ExprEval.compareClass(finalResult, expectedClass)) {
            throw new Exception("Wrong class for final Expression evaluation");
        }
        if (!ExprEval.compareValue(finalResult, expectedValue)) {
            throw new Exception("Wrong value for final Expression evaluation");
        }
    }
}

