/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.httptunnel.tunnel.servlet;

import java.util.Hashtable;
import java.util.StringTokenizer;

class HttpUtils {
    private HttpUtils() {
    }

    static Hashtable<String, String[]> parseQueryString(String s) {
        String[] valArray = null;
        if (s == null) {
            throw new IllegalArgumentException();
        }
        Hashtable<String, String[]> ht = new Hashtable<String, String[]>();
        StringBuilder sb = new StringBuilder();
        StringTokenizer st = new StringTokenizer(s, "&");
        while (st.hasMoreTokens()) {
            String pair = st.nextToken();
            int pos = pair.indexOf(61);
            if (pos == -1) {
                throw new IllegalArgumentException();
            }
            String key = HttpUtils.parseName(pair.substring(0, pos), sb);
            String val = HttpUtils.parseName(pair.substring(pos + 1, pair.length()), sb);
            if (ht.containsKey(key)) {
                String[] oldVals = ht.get(key);
                valArray = new String[oldVals.length + 1];
                System.arraycopy(oldVals, 0, valArray, 0, oldVals.length);
                valArray[oldVals.length] = val;
            } else {
                valArray = new String[]{val};
            }
            ht.put(key, valArray);
        }
        return ht;
    }

    private static String parseName(String s, StringBuilder sb) {
        sb.setLength(0);
        block7: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '+': {
                    sb.append(' ');
                    continue block7;
                }
                case '%': {
                    try {
                        sb.append((char)Integer.parseInt(s.substring(i + 1, i + 3), 16));
                        i += 2;
                        continue block7;
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException();
                    }
                    catch (StringIndexOutOfBoundsException e) {
                        String rest = s.substring(i);
                        sb.append(rest);
                        if (rest.length() != 2) continue block7;
                        ++i;
                        continue block7;
                    }
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }
}

