/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.rm.protocol.wsrm200502;

import com.sun.xml.ws.rx.rm.localization.LocalizationMessages;
import com.sun.xml.ws.rx.rm.protocol.wsrm200502.Identifier;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAnyAttribute;
import jakarta.xml.bind.annotation.XmlAnyElement;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"identifier", "acknowledgementRange", "bufferRemaining", "nack", "any"})
@XmlRootElement(name="SequenceAcknowledgement", namespace="http://schemas.xmlsoap.org/ws/2005/02/rm")
public class SequenceAcknowledgementElement {
    @XmlElement(name="Identifier", namespace="http://schemas.xmlsoap.org/ws/2005/02/rm")
    protected Identifier identifier;
    @XmlElement(name="AcknowledgementRange", namespace="http://schemas.xmlsoap.org/ws/2005/02/rm")
    protected List<AcknowledgementRange> acknowledgementRange;
    @XmlElement(name="Nack", namespace="http://schemas.xmlsoap.org/ws/2005/02/rm")
    protected List<BigInteger> nack;
    @XmlElement(name="BufferRemaining", namespace="http://schemas.microsoft.com/ws/2006/05/rm")
    protected Integer bufferRemaining;
    @XmlAnyElement(lax=true)
    protected List<Object> any;
    @XmlAnyAttribute
    private Map<QName, String> otherAttributes = new HashMap<QName, String>();

    public Identifier getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(Identifier value) {
        this.identifier = value;
    }

    public List<AcknowledgementRange> getAcknowledgementRange() {
        if (this.acknowledgementRange == null) {
            this.acknowledgementRange = new ArrayList<AcknowledgementRange>();
        }
        return this.acknowledgementRange;
    }

    public List<BigInteger> getNack() {
        if (this.nack == null) {
            this.nack = new ArrayList<BigInteger>();
        }
        return this.nack;
    }

    public List<Object> getAny() {
        if (this.any == null) {
            this.any = new ArrayList<Object>();
        }
        return this.any;
    }

    public Map<QName, String> getOtherAttributes() {
        return this.otherAttributes;
    }

    public void setId(String idString) {
        Identifier newId = new Identifier();
        newId.setValue(idString);
        this.setIdentifier(newId);
    }

    public String getId() {
        return this.getIdentifier().getValue();
    }

    public int getBufferRemaining() {
        if (this.bufferRemaining == null) {
            return -1;
        }
        return this.bufferRemaining;
    }

    public void setBufferRemaining(int value) {
        this.bufferRemaining = value;
    }

    public void addAckRange(long lower, long upper) {
        if (this.nack != null) {
            throw new IllegalArgumentException(LocalizationMessages.WSRM_4002_BOTH_ACKS_AND_NACKS_MESSAGE());
        }
        if (lower > upper) {
            throw new IllegalArgumentException(LocalizationMessages.WSRM_4003_UPPERBOUND_LESSTHAN_LOWERBOUND_MESSAGE());
        }
        AcknowledgementRange range = new AcknowledgementRange();
        range.setLower(BigInteger.valueOf(lower));
        range.setUpper(BigInteger.valueOf(upper));
        this.getAcknowledgementRange().add(range);
    }

    public void addNack(long index) {
        if (this.acknowledgementRange != null) {
            throw new IllegalArgumentException(LocalizationMessages.WSRM_4002_BOTH_ACKS_AND_NACKS_MESSAGE());
        }
        this.getNack().add(BigInteger.valueOf(index));
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(LocalizationMessages.WSRM_4004_SEQUENCE_ACKNOWLEDGEMENT_TOSTRING_STRING(this.getId(), this.getBufferRemaining()));
        List<AcknowledgementRange> ranges = this.getAcknowledgementRange();
        if (ranges != null) {
            for (AcknowledgementRange range : ranges) {
                buffer.append("\t\t").append(range.toString()).append('\n');
            }
        }
        return buffer.toString();
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="")
    public static class AcknowledgementRange {
        @XmlAttribute(name="Lower", required=true)
        protected BigInteger lower;
        @XmlAttribute(name="Upper", required=true)
        protected BigInteger upper;
        @XmlAnyAttribute
        private Map<QName, String> otherAttributes = new HashMap<QName, String>();

        public BigInteger getLower() {
            return this.lower;
        }

        public void setLower(BigInteger value) {
            this.lower = value;
        }

        public BigInteger getUpper() {
            return this.upper;
        }

        public void setUpper(BigInteger value) {
            this.upper = value;
        }

        public Map<QName, String> getOtherAttributes() {
            return this.otherAttributes;
        }

        public String toString() {
            return "AcknowledgementRange (" + this.lower.intValue() + "," + this.upper.intValue() + ")";
        }
    }
}

