/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.rm.runtime.delivery;

import com.sun.xml.ws.rx.RxRuntimeException;
import com.sun.xml.ws.rx.rm.localization.LocalizationMessages;
import com.sun.xml.ws.rx.rm.runtime.ApplicationMessage;
import com.sun.xml.ws.rx.rm.runtime.delivery.DeliveryQueue;
import com.sun.xml.ws.rx.rm.runtime.delivery.Postman;
import java.util.concurrent.atomic.AtomicBoolean;

final class SimpleDeliveryQueue
implements DeliveryQueue {
    private final Postman postman;
    private final Postman.Callback deliveryCallback;
    private final AtomicBoolean isClosed;

    SimpleDeliveryQueue(Postman postman, Postman.Callback deliveryCallback) {
        this.postman = postman;
        this.deliveryCallback = deliveryCallback;
        this.isClosed = new AtomicBoolean(false);
    }

    @Override
    public void put(ApplicationMessage message) throws RxRuntimeException {
        if (this.isClosed.get()) {
            throw new RxRuntimeException(LocalizationMessages.WSRM_1160_DELIVERY_QUEUE_CLOSED());
        }
        this.postman.deliver(message, this.deliveryCallback);
    }

    @Override
    public long getRemainingMessageBufferSize() {
        return -1L;
    }

    @Override
    public void onSequenceAcknowledgement() {
    }

    @Override
    public void close() {
        this.isClosed.set(true);
    }
}

