/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.util;

import com.sun.messaging.jmq.util.LockTable;
import com.sun.messaging.jmq.util.LoggerWrapper;

public class MQThreadGroup
extends ThreadGroup {
    private static final System.Logger defaultLogger = System.getLogger(LockTable.class.getName());
    private LoggerWrapper logger = null;
    private String uncaughtExMsg = null;

    public MQThreadGroup(String name, LoggerWrapper logger, String threadUncaughtExWarnMsg) {
        super(name);
        this.logger = logger;
        this.uncaughtExMsg = threadUncaughtExWarnMsg;
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        if (this.logger == null) {
            defaultLogger.log(System.Logger.Level.WARNING, e.getMessage(), e);
        } else {
            this.logger.logWarn(this.uncaughtExMsg + " [" + String.valueOf(t) + "]", e);
        }
    }
}

