/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.generator.database;

import com.sun.jdo.spi.persistence.generator.database.LogHelperDatabaseGenerator;
import com.sun.jdo.spi.persistence.generator.database.MappingPolicy;
import com.sun.jdo.spi.persistence.utility.StringHelper;
import com.sun.jdo.spi.persistence.utility.logging.Logger;

class JDBCInfo {
    private static final String INDICATOR_TYPE = "jdbc-type";
    private static final String INDICATOR_NULLABLE = "jdbc-nullable";
    private static final String INDICATOR_PRECISION = "jdbc-precision";
    private static final String INDICATOR_SCALE = "jdbc-scale";
    private static final String INDICATOR_LENGTH = "jdbc-maximum-length";
    private static final String NO_LENGTH_INDICATOR = "null";
    private static final Integer NO_LENGTH = new Integer(-1);
    private static final Logger logger = LogHelperDatabaseGenerator.getLogger();
    private int jdbcType;
    private boolean nullable = false;
    private Integer precision = null;
    private Integer scale = null;
    private Integer length = null;
    private byte fieldsWithValues = 0;
    private static final byte MASK_JDBC_TYPE = 1;
    private static final byte MASK_NULLABLE = 2;
    private static final byte MASK_PRECISION = 4;
    private static final byte MASK_SCALE = 8;
    private static final byte MASK_LENGTH = 16;
    private static final byte MASK_ALL = 31;

    JDBCInfo(int jdbcType, Integer precision, Integer scale, Integer length, boolean nullable) {
        this.jdbcType = jdbcType;
        this.precision = precision;
        this.scale = scale;
        this.length = length;
        this.nullable = nullable;
        this.fieldsWithValues = (byte)31;
    }

    JDBCInfo() {
    }

    void setValue(String value, String indicator) throws IllegalJDBCTypeException {
        if (indicator.equals(INDICATOR_TYPE)) {
            if (!StringHelper.isEmpty(value)) {
                Integer type = MappingPolicy.getJdbcType(value);
                if (null == type) {
                    throw new IllegalJDBCTypeException();
                }
                this.jdbcType = type;
                this.fieldsWithValues = (byte)(this.fieldsWithValues | 1);
            }
        } else if (indicator.equals(INDICATOR_NULLABLE)) {
            this.nullable = StringHelper.isEmpty(value) ? false : Boolean.valueOf(value);
            this.fieldsWithValues = (byte)(this.fieldsWithValues | 2);
        } else if (indicator.equals(INDICATOR_PRECISION)) {
            this.precision = this.getIntegerValue(value);
            this.fieldsWithValues = (byte)(this.fieldsWithValues | 4);
        } else if (indicator.equals(INDICATOR_SCALE)) {
            this.scale = this.getIntegerValue(value);
            this.fieldsWithValues = (byte)(this.fieldsWithValues | 8);
        } else if (indicator.equals(INDICATOR_LENGTH)) {
            this.length = value.trim().equals(NO_LENGTH_INDICATOR) ? NO_LENGTH : this.getIntegerValue(value);
            this.fieldsWithValues = (byte)(this.fieldsWithValues | 0x10);
        }
    }

    private Integer getIntegerValue(String s) {
        Integer rc = null;
        if (!StringHelper.isEmpty(s)) {
            rc = new Integer(s);
        }
        return rc;
    }

    void complete(JDBCInfo other) {
        if (logger.isLoggable(300)) {
            logger.finest("Entering JDBCInfo.complete: \nthis: " + String.valueOf(this) + "\nother: " + String.valueOf(other));
        }
        if (31 != this.fieldsWithValues) {
            if ((this.fieldsWithValues & 1) == 0) {
                this.jdbcType = other.jdbcType;
            }
            if ((this.fieldsWithValues & 2) == 0) {
                this.nullable = other.nullable;
            }
            if ((this.fieldsWithValues & 4) == 0) {
                this.precision = other.precision;
            }
            if ((this.fieldsWithValues & 8) == 0) {
                this.scale = other.scale;
            }
            if ((this.fieldsWithValues & 0x10) == 0 || NO_LENGTH.equals(other.length) || other.length < this.length) {
                this.length = other.length;
            }
            this.fieldsWithValues = (byte)31;
        }
        if (logger.isLoggable(300)) {
            logger.finest("Leaving JDBCInfo.complete: \nthis: " + String.valueOf(this));
        }
    }

    boolean isComplete() {
        return this.fieldsWithValues == 31;
    }

    void override(JDBCInfo other) {
        if (null != other) {
            this.jdbcType = other.jdbcType;
        }
    }

    public boolean hasJdbcType() {
        return (this.fieldsWithValues & 1) == 1;
    }

    public int getJdbcType() {
        return this.jdbcType;
    }

    public boolean getNullable() {
        return this.nullable;
    }

    public Integer getPrecision() {
        return this.precision;
    }

    public Integer getScale() {
        return this.scale;
    }

    public Integer getLength() {
        return NO_LENGTH.equals(this.length) ? null : this.length;
    }

    public String toString() {
        return "JDBCInfo: jdbcType=" + this.jdbcType + " nullable=" + this.nullable + " precision=" + this.precision + " scale=" + this.scale + " length=" + this.length + " fieldsWithValues=0x" + Integer.toHexString(this.fieldsWithValues);
    }

    static class IllegalJDBCTypeException
    extends Exception {
        IllegalJDBCTypeException() {
        }
    }
}

