/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.management.agent;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.auth.AccessController;
import com.sun.messaging.jmq.jmsserver.auth.MQAuthenticator;
import com.sun.messaging.jmq.jmsserver.management.agent.ConnectorServerInfo;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.util.log.Logger;
import java.net.InetAddress;
import java.rmi.server.RemoteServer;
import javax.management.remote.JMXAuthenticator;
import javax.security.auth.Subject;

public class MQJMXAuthenticator
implements JMXAuthenticator {
    private Logger logger = Globals.getLogger();
    private ConnectorServerInfo csi;
    private BrokerResources rb = Globals.getBrokerResources();

    public MQJMXAuthenticator(ConnectorServerInfo csi) {
        this.csi = csi;
    }

    @Override
    public Subject authenticate(Object credentials) {
        if (credentials == null) {
            String errStr = this.rb.getString("B2143", this.csi.getName());
            this.logger.log(16, errStr);
            throw new SecurityException(errStr);
        }
        if (!(credentials instanceof String[])) {
            String errStr = this.rb.getString("B2144", this.csi.getName());
            this.logger.log(16, errStr);
            throw new SecurityException(errStr);
        }
        String[] up = (String[])credentials;
        String username = up[0];
        String passwd = up[1];
        String clientIP = null;
        MQAuthenticator a = null;
        try {
            a = new MQAuthenticator("admin", 1);
        }
        catch (Exception e) {
            String errStr = this.rb.getString("B2172", e.toString());
            this.logger.log(16, errStr);
            throw new SecurityException(errStr);
        }
        if (this.csi.getConfiguredJMXServiceURL().getProtocol().equals("rmi")) {
            try {
                clientIP = RemoteServer.getClientHost();
                InetAddress clientHostIA = InetAddress.getByName(clientIP);
                clientIP = clientHostIA.getHostAddress();
            }
            catch (Exception e) {
                String errStr = this.rb.getString("B2198", this.csi.getName(), e.toString());
                this.logger.log(16, errStr);
                throw new SecurityException(errStr);
            }
            AccessController ac = a.getAccessController();
            if (ac != null) {
                ac.setClientIP(clientIP);
            }
        }
        try {
            a.authenticate(username, passwd);
        }
        catch (Exception e) {
            String errStr = this.rb.getString("B2146", this.csi.getName(), e.toString());
            this.logger.log(16, errStr);
            throw new SecurityException(errStr);
        }
        return new Subject();
    }
}

