/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.net;

import java.util.ArrayList;
import java.util.List;
import javax.transaction.xa.Xid;
import org.apache.derby.client.ClientXid;
import org.apache.derby.client.am.ConnectionCallbackInterface;
import org.apache.derby.client.am.DisconnectException;
import org.apache.derby.client.net.CodePoint;
import org.apache.derby.client.net.NetAgent;
import org.apache.derby.client.net.NetConnection;
import org.apache.derby.client.net.NetResultSetReply;
import org.apache.derby.client.net.NetXACallInfo;

class NetXAConnectionReply
extends NetResultSetReply {
    NetXAConnectionReply(NetAgent netAgent, int n) {
        super(netAgent, n);
    }

    @Override
    public void readLocalXAStart(ConnectionCallbackInterface connectionCallbackInterface) throws DisconnectException {
    }

    @Override
    public void readLocalXACommit(ConnectionCallbackInterface connectionCallbackInterface) throws DisconnectException {
        this.startSameIdChainParse();
        this.parseSYNCCTLreply(connectionCallbackInterface);
        this.endOfSameIdChainData();
        NetXACallInfo netXACallInfo = this.netAgent_.netConnection_.xares_.callInfoArray_[this.netAgent_.netConnection_.currXACallInfoOffset_];
        connectionCallbackInterface.completeLocalCommit();
    }

    @Override
    public void readLocalXARollback(ConnectionCallbackInterface connectionCallbackInterface) throws DisconnectException {
        this.startSameIdChainParse();
        this.parseSYNCCTLreply(connectionCallbackInterface);
        this.endOfSameIdChainData();
        connectionCallbackInterface.completeLocalRollback();
    }

    @Override
    void readXaStartUnitOfWork(NetConnection netConnection) throws DisconnectException {
        this.startSameIdChainParse();
        this.parseSYNCCTLreply(netConnection);
        NetXACallInfo netXACallInfo = netConnection.xares_.callInfoArray_[netConnection.currXACallInfoOffset_];
        boolean bl = netXACallInfo.xaFlags_ == 0x200000 || netXACallInfo.xaFlags_ == 0x8000000;
        netConnection.xares_.setKeepCurrentIsolationLevel(bl);
        this.endOfSameIdChainData();
    }

    @Override
    int readXaEndUnitOfWork(NetConnection netConnection) throws DisconnectException {
        netConnection.xares_.setKeepCurrentIsolationLevel(false);
        NetXACallInfo netXACallInfo = netConnection.xares_.callInfoArray_[netConnection.currXACallInfoOffset_];
        int n = netXACallInfo.xaFlags_;
        this.startSameIdChainParse();
        this.parseSYNCCTLreply(netConnection);
        this.endOfSameIdChainData();
        if (n == 0x20000000) {
            return 100;
        }
        return 0;
    }

    @Override
    int readXaPrepare(NetConnection netConnection) throws DisconnectException {
        this.startSameIdChainParse();
        int n = this.parseSYNCCTLreply(netConnection);
        this.endOfSameIdChainData();
        return n;
    }

    @Override
    void readXaCommit(NetConnection netConnection) throws DisconnectException {
        this.startSameIdChainParse();
        this.parseSYNCCTLreply(netConnection);
        this.endOfSameIdChainData();
        NetXACallInfo netXACallInfo = netConnection.xares_.callInfoArray_[netConnection.currXACallInfoOffset_];
        netConnection.completeLocalCommit();
    }

    @Override
    int readXaRollback(NetConnection netConnection) throws DisconnectException {
        this.startSameIdChainParse();
        this.parseSYNCCTLreply(netConnection);
        this.endOfSameIdChainData();
        NetXACallInfo netXACallInfo = netConnection.xares_.callInfoArray_[netConnection.currXACallInfoOffset_];
        netConnection.completeLocalRollback();
        return 0;
    }

    @Override
    void readXaRecover(NetConnection netConnection) throws DisconnectException {
        this.startSameIdChainParse();
        this.parseSYNCCTLreply(netConnection);
        this.endOfSameIdChainData();
    }

    @Override
    void readXaForget(NetConnection netConnection) throws DisconnectException {
        this.startSameIdChainParse();
        this.parseSYNCCTLreply(netConnection);
        this.endOfSameIdChainData();
    }

    @Override
    int parseSYNCCRD(ConnectionCallbackInterface connectionCallbackInterface) throws DisconnectException {
        boolean bl = false;
        int n = CodePoint.SVRCOD_INFO;
        int n2 = 0;
        byte by = 0;
        NetConnection netConnection = this.netAgent_.netConnection_;
        this.parseLengthAndMatchCodePoint(4680);
        this.pushLengthOnCollectionStack();
        int n3 = this.peekCodePoint();
        while (n3 != -1) {
            boolean bl2 = false;
            if (n3 == 4425) {
                bl2 = true;
                bl = this.checkAndGetReceivedFlag(bl);
                n = this.parseSVRCOD(CodePoint.SVRCOD_ERROR, CodePoint.SVRCOD_ERROR);
                n3 = this.peekCodePoint();
            }
            if (n3 == 6404) {
                bl2 = true;
                netConnection.xares_.callInfoArray_[netConnection.currXACallInfoOffset_].xaRetVal_ = n2 = this.parseXARETVAL();
                n3 = this.peekCodePoint();
            }
            if (n3 == 4487) {
                bl2 = true;
                by = this.parseSYNCTYPE();
                n3 = this.peekCodePoint();
            }
            if (n3 == 6405) {
                bl2 = true;
                netConnection.setIndoubtTransactions(this.parseIndoubtList());
                n3 = this.peekCodePoint();
            }
            if (bl2) continue;
            this.doPrmnsprmSemantics(n3);
        }
        this.popCollectionStack();
        return n2;
    }

    @Override
    int parseXARETVAL() throws DisconnectException {
        this.parseLengthAndMatchCodePoint(6404);
        return this.readInt();
    }

    @Override
    byte parseSYNCTYPE() throws DisconnectException {
        this.parseLengthAndMatchCodePoint(4487);
        return this.readByte();
    }

    @Override
    int parseSYNCCTLreply(ConnectionCallbackInterface connectionCallbackInterface) throws DisconnectException {
        int n = this.peekCodePoint();
        if (n != 4680) {
            this.parseSYNCCTLError(n);
            return -1;
        }
        int n2 = this.parseSYNCCRD(connectionCallbackInterface);
        n = this.peekCodePoint();
        while (n == 9236) {
            String string = this.parseSQLSTT();
            n = this.peekCodePoint();
        }
        if (n == 49152) {
            this.parsePBSD();
        }
        return n2;
    }

    private String parseSQLSTT() throws DisconnectException {
        this.parseLengthAndMatchCodePoint(9236);
        return this.parseSQLSTTGRPNOCMorNOCS();
    }

    private String parseSQLSTTGRPNOCMorNOCS() throws DisconnectException {
        int n = this.readUnsignedByte();
        int n2 = 0;
        String string = null;
        int n3 = 0;
        if (n == 255) {
            n2 = this.readUnsignedByte();
            if (n2 == 255) {
                this.doDtamchrmSemantics();
            }
            n3 = this.readInt();
            string = this.readString(n3, this.netAgent_.targetTypdef_.getCcsidSbcEncoding());
        } else {
            n3 = this.readInt();
            string = this.readString(n3, this.netAgent_.targetTypdef_.getCcsidMbcEncoding());
            n2 = this.readUnsignedByte();
        }
        return string;
    }

    @Override
    int parseXIDCNT() throws DisconnectException {
        this.parseLengthAndMatchCodePoint(6406);
        return this.readUnsignedShort();
    }

    @Override
    Xid parseXID() throws DisconnectException {
        this.parseLengthAndMatchCodePoint(6145);
        int n = this.readInt();
        int n2 = this.readInt();
        int n3 = this.readInt();
        byte[] byArray = this.readBytes(n2);
        byte[] byArray2 = this.readBytes(n3);
        return new ClientXid(n, byArray, byArray2);
    }

    @Override
    List<Xid> parseIndoubtList() throws DisconnectException {
        this.peekCodePoint();
        this.parseLengthAndMatchCodePoint(6405);
        int n = this.peekCodePoint();
        if (n == 6406) {
            this.parseXIDCNT();
            n = this.peekCodePoint();
        }
        ArrayList<Xid> arrayList = new ArrayList<Xid>();
        while (n == 6145) {
            Xid xid = this.parseXID();
            arrayList.add(xid);
            n = this.peekCodePoint();
        }
        return arrayList;
    }
}

