/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.jms.system;

import com.sun.enterprise.connectors.ConnectorRuntime;
import jakarta.jms.ConnectionFactory;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.glassfish.api.naming.DefaultResourceProxy;
import org.glassfish.api.naming.NamedNamingObjectProxy;
import org.glassfish.api.naming.NamespacePrefixes;
import org.glassfish.api.naming.SimpleJndiName;
import org.jvnet.hk2.annotations.Service;

@Service
@NamespacePrefixes(value={"java:comp/DefaultJMSConnectionFactory"})
public class DefaultJMSConnectionFactory
implements NamedNamingObjectProxy,
DefaultResourceProxy {
    static final String DEFAULT_CF = "java:comp/DefaultJMSConnectionFactory";
    static final String DEFAULT_CF_PHYS = "jms/__defaultConnectionFactory";
    private ConnectionFactory connectionFactory;
    private ConnectionFactory connectionFactoryPM;

    public Object handle(String name) throws NamingException {
        ConnectionFactory cachedCF = null;
        boolean isCFPM = false;
        if (name != null && name.endsWith("__pm")) {
            cachedCF = this.connectionFactoryPM;
            isCFPM = true;
        } else {
            cachedCF = this.connectionFactory;
        }
        if (cachedCF == null) {
            InitialContext ctx = new InitialContext();
            if (isCFPM) {
                ConnectorRuntime connectorRuntime = ConnectorRuntime.getRuntime();
                this.connectionFactoryPM = cachedCF = (ConnectionFactory)connectorRuntime.lookupPMResource(SimpleJndiName.of((String)DEFAULT_CF_PHYS), false);
            } else {
                this.connectionFactory = cachedCF = (ConnectionFactory)ctx.lookup(DEFAULT_CF_PHYS);
            }
        }
        return cachedCF;
    }

    public String getPhysicalName() {
        return DEFAULT_CF_PHYS;
    }

    public String getLogicalName() {
        return DEFAULT_CF;
    }
}

