/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.logger;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class FileLoggerHandler
extends Handler {
    private static final int LOG_QUEUE_SIZE = 5000;
    private static final int FLUSH_FREQUENCY = 1;
    private volatile PrintWriter printWriter;
    private final String logFile;
    private final AtomicInteger association = new AtomicInteger(0);
    private final AtomicBoolean done = new AtomicBoolean(false);
    private final BlockingQueue<LogRecord> pendingRecords = new ArrayBlockingQueue<LogRecord>(5000);
    private final Thread pump;

    FileLoggerHandler(String logFile) {
        this.setLevel(Level.ALL);
        this.logFile = logFile;
        try {
            this.printWriter = new PrintWriter(new FileOutputStream(logFile, true));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.pump = new Thread(){

            @Override
            public void run() {
                try {
                    while (!FileLoggerHandler.this.done.get()) {
                        FileLoggerHandler.this.log();
                    }
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
        };
        this.pump.start();
    }

    private void writeLogRecord(LogRecord record) {
        if (this.printWriter != null) {
            this.printWriter.write(this.getFormatter().format(record));
            this.printWriter.flush();
        }
    }

    private void log() {
        try {
            this.writeLogRecord(this.pendingRecords.take());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        ArrayList list = new ArrayList();
        int numOfRecords = this.pendingRecords.drainTo(list, 1);
        for (int i = 0; i < numOfRecords; ++i) {
            this.writeLogRecord((LogRecord)list.get(i));
        }
        this.flush();
    }

    public int associate() {
        return this.association.incrementAndGet();
    }

    public int disassociate() {
        return this.association.decrementAndGet();
    }

    public boolean isAssociated() {
        return this.association.get() > 0;
    }

    @Override
    public void publish(LogRecord record) {
        if (this.done.get()) {
            return;
        }
        if (this.getFilter() != null && !this.getFilter().isLoggable(record)) {
            return;
        }
        try {
            this.pendingRecords.add(record);
        }
        catch (IllegalStateException e) {
            try {
                this.pendingRecords.put(record);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.done.set(true);
        this.pump.interrupt();
        int size = this.pendingRecords.size();
        if (size > 0) {
            ArrayList records = new ArrayList(size);
            this.pendingRecords.drainTo(records, size);
            for (LogRecord record : records) {
                this.writeLogRecord(record);
            }
        }
        if (this.printWriter != null) {
            try {
                this.printWriter.flush();
            }
            catch (Exception exception) {
            }
            finally {
                this.printWriter.close();
            }
        }
    }

    @Override
    public void flush() {
        if (this.printWriter != null) {
            this.printWriter.flush();
        }
    }

    public String getLogFile() {
        return this.logFile;
    }
}

