/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.catalog;

import java.util.Properties;
import org.apache.derby.catalog.DefaultInfo;
import org.apache.derby.catalog.TypeDescriptor;
import org.apache.derby.catalog.UUID;
import org.apache.derby.catalog.types.DefaultInfoImpl;
import org.apache.derby.iapi.services.uuid.UUIDFactory;
import org.apache.derby.iapi.sql.dictionary.CatalogRowFactory;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDescriptorGenerator;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SystemColumn;
import org.apache.derby.iapi.sql.dictionary.TupleDescriptor;
import org.apache.derby.iapi.sql.dictionary.UniqueTupleDescriptor;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.ExecutionFactory;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.DataValueFactory;
import org.apache.derby.iapi.types.SQLBoolean;
import org.apache.derby.iapi.types.SQLChar;
import org.apache.derby.iapi.types.SQLInteger;
import org.apache.derby.iapi.types.SQLLongint;
import org.apache.derby.iapi.types.SQLVarchar;
import org.apache.derby.iapi.types.UserType;
import org.apache.derby.impl.sql.catalog.SystemColumnImpl;
import org.apache.derby.shared.common.error.StandardException;

public class SYSCOLUMNSRowFactory
extends CatalogRowFactory {
    static final String TABLENAME_STRING = "SYSCOLUMNS";
    protected static final int SYSCOLUMNS_COLUMN_COUNT = 10;
    protected static final int SYSCOLUMNS_TABLEID = 1;
    protected static final int SYSCOLUMNS_REFERENCEID = 1;
    protected static final int SYSCOLUMNS_COLUMNNAME = 2;
    protected static final int SYSCOLUMNS_COLUMNNUMBER = 3;
    protected static final int SYSCOLUMNS_COLUMNDATATYPE = 4;
    protected static final int SYSCOLUMNS_COLUMNDEFAULT = 5;
    protected static final int SYSCOLUMNS_COLUMNDEFAULTID = 6;
    protected static final int SYSCOLUMNS_AUTOINCREMENTVALUE = 7;
    protected static final int SYSCOLUMNS_AUTOINCREMENTSTART = 8;
    protected static final int SYSCOLUMNS_AUTOINCREMENTINC = 9;
    protected static final int SYSCOLUMNS_AUTOINCREMENTINCCYCLE = 10;
    protected static final int SYSCOLUMNS_INDEX1_ID = 0;
    protected static final int SYSCOLUMNS_INDEX2_ID = 1;
    private static final boolean[] uniqueness = new boolean[]{true, false};
    private static final String[] uuids = new String[]{"8000001e-00d0-fd77-3ed8-000a0a0b1900", "80000029-00d0-fd77-3ed8-000a0a0b1900", "80000020-00d0-fd77-3ed8-000a0a0b1900", "6839c016-00d9-2829-dfcd-000a0a411400"};
    private static final int[][] indexColumnPositions = new int[][]{{1, 2}, {6}};
    private final DataDictionary dataDictionary;

    SYSCOLUMNSRowFactory(DataDictionary dataDictionary, UUIDFactory uUIDFactory, ExecutionFactory executionFactory, DataValueFactory dataValueFactory) {
        this(dataDictionary, uUIDFactory, executionFactory, dataValueFactory, TABLENAME_STRING);
    }

    SYSCOLUMNSRowFactory(DataDictionary dataDictionary, UUIDFactory uUIDFactory, ExecutionFactory executionFactory, DataValueFactory dataValueFactory, String string) {
        super(uUIDFactory, executionFactory, dataValueFactory);
        this.dataDictionary = dataDictionary;
        this.initInfo(10, string, indexColumnPositions, uniqueness, uuids);
    }

    @Override
    public ExecRow makeRow(TupleDescriptor tupleDescriptor, TupleDescriptor tupleDescriptor2) throws StandardException {
        return this.makeRow(tupleDescriptor, this.getHeapColumnCount());
    }

    @Override
    public ExecRow makeEmptyRowForCurrentVersion() throws StandardException {
        return this.makeRow(null, 10);
    }

    private ExecRow makeRow(TupleDescriptor tupleDescriptor, int n) throws StandardException {
        ColumnDescriptor columnDescriptor;
        String string = null;
        String string2 = null;
        String string3 = null;
        Integer n2 = null;
        TypeDescriptor typeDescriptor = null;
        Object object = null;
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        boolean bl = false;
        long l4 = -1L;
        if (tupleDescriptor != null) {
            columnDescriptor = (ColumnDescriptor)tupleDescriptor;
            typeDescriptor = columnDescriptor.getType().getCatalogType();
            string3 = columnDescriptor.getReferencingUUID().toString();
            string = columnDescriptor.getColumnName();
            n2 = columnDescriptor.getPosition();
            l = columnDescriptor.getAutoincStart();
            l2 = columnDescriptor.getAutoincInc();
            l3 = columnDescriptor.getAutoincValue();
            l4 = columnDescriptor.getAutoinc_create_or_modify_Start_Increment();
            bl = columnDescriptor.getAutoincCycle();
            object = columnDescriptor.getDefaultInfo() != null ? columnDescriptor.getDefaultInfo() : columnDescriptor.getDefaultValue();
            if (columnDescriptor.getDefaultUUID() != null) {
                string2 = columnDescriptor.getDefaultUUID().toString();
            }
        }
        ExecRow execRow = this.getExecutionFactory().getValueRow(n);
        execRow.setColumn(1, new SQLChar(string3));
        execRow.setColumn(2, new SQLVarchar(string));
        execRow.setColumn(3, new SQLInteger(n2));
        execRow.setColumn(4, new UserType(typeDescriptor));
        execRow.setColumn(5, new UserType(object));
        execRow.setColumn(6, new SQLChar(string2));
        if (l4 == 0L || l4 == 2L || l4 == 3L) {
            execRow.setColumn(7, new SQLLongint(l3));
            execRow.setColumn(8, new SQLLongint(l));
            execRow.setColumn(9, new SQLLongint(l2));
            if (execRow.nColumns() >= 10) {
                execRow.setColumn(10, new SQLBoolean(bl));
            }
        } else if (l4 == 1L) {
            columnDescriptor = (ColumnDescriptor)tupleDescriptor;
            execRow.setColumn(7, new SQLLongint(l));
            execRow.setColumn(8, new SQLLongint(l));
            execRow.setColumn(9, new SQLLongint(columnDescriptor.getTableDescriptor().getColumnDescriptor(string).getAutoincInc()));
            if (execRow.nColumns() >= 10) {
                execRow.setColumn(10, new SQLBoolean(bl));
            }
        } else if (l4 == 4L) {
            columnDescriptor = (ColumnDescriptor)tupleDescriptor;
            execRow.setColumn(7, new SQLLongint(columnDescriptor.getTableDescriptor().getColumnDescriptor(string).getAutoincValue()));
            execRow.setColumn(8, new SQLLongint(columnDescriptor.getTableDescriptor().getColumnDescriptor(string).getAutoincStart()));
            execRow.setColumn(9, new SQLLongint(columnDescriptor.getTableDescriptor().getColumnDescriptor(string).getAutoincInc()));
            if (execRow.nColumns() >= 10) {
                execRow.setColumn(10, new SQLBoolean(bl));
            }
        } else {
            execRow.setColumn(7, new SQLLongint());
            execRow.setColumn(8, new SQLLongint());
            execRow.setColumn(9, new SQLLongint());
            if (execRow.nColumns() >= 10) {
                execRow.setColumn(10, new SQLBoolean(bl));
            }
        }
        return execRow;
    }

    @Override
    public Properties getCreateHeapProperties() {
        Properties properties = new Properties();
        properties.put("derby.storage.pageSize", "4096");
        properties.put("derby.storage.pageReservedSpace", "0");
        properties.put("derby.storage.minimumRecordSize", "1");
        return properties;
    }

    @Override
    public Properties getCreateIndexProperties(int n) {
        Properties properties = new Properties();
        properties.put("derby.storage.pageSize", "4096");
        return properties;
    }

    @Override
    public TupleDescriptor buildDescriptor(ExecRow execRow, TupleDescriptor tupleDescriptor, DataDictionary dataDictionary) throws StandardException {
        DataValueDescriptor dataValueDescriptor;
        DefaultInfoImpl defaultInfoImpl = null;
        DataValueDescriptor dataValueDescriptor2 = null;
        UUID uUID = null;
        UUID uUID2 = null;
        UUIDFactory uUIDFactory = this.getUUIDFactory();
        boolean bl = false;
        DataDescriptorGenerator dataDescriptorGenerator = dataDictionary.getDataDescriptorGenerator();
        uUID2 = tupleDescriptor != null ? ((UniqueTupleDescriptor)tupleDescriptor).getUUID() : uUIDFactory.recreateUUID(execRow.getColumn(1).getString());
        Object object = execRow.getColumn(5).getObject();
        if (object instanceof DataValueDescriptor) {
            dataValueDescriptor2 = (DataValueDescriptor)object;
        } else if (object instanceof DefaultInfoImpl) {
            defaultInfoImpl = (DefaultInfoImpl)object;
            dataValueDescriptor2 = defaultInfoImpl.getDefaultValue();
        }
        String string = execRow.getColumn(6).getString();
        if (string != null) {
            uUID = uUIDFactory.recreateUUID(string);
        }
        String string2 = execRow.getColumn(2).getString();
        int n = execRow.getColumn(3).getInt();
        TypeDescriptor typeDescriptor = (TypeDescriptor)execRow.getColumn(4).getObject();
        DataTypeDescriptor dataTypeDescriptor = DataTypeDescriptor.getType(typeDescriptor);
        long l = execRow.getColumn(7).getLong();
        long l2 = execRow.getColumn(8).getLong();
        long l3 = execRow.getColumn(9).getLong();
        if (execRow.nColumns() >= 10) {
            dataValueDescriptor = execRow.getColumn(10);
            bl = dataValueDescriptor.getBoolean();
        }
        dataValueDescriptor = execRow.getColumn(8);
        l2 = dataValueDescriptor.getLong();
        dataValueDescriptor = execRow.getColumn(9);
        l3 = dataValueDescriptor.getLong();
        ColumnDescriptor columnDescriptor = new ColumnDescriptor(string2, n, dataTypeDescriptor, dataValueDescriptor2, (DefaultInfo)defaultInfoImpl, uUID2, uUID, l2, l3, l, bl);
        return columnDescriptor;
    }

    @Override
    public int getPrimaryKeyIndexNumber() {
        return 0;
    }

    @Override
    public SystemColumn[] buildColumnList() throws StandardException {
        return new SystemColumn[]{SystemColumnImpl.getUUIDColumn("REFERENCEID", false), SystemColumnImpl.getIdentifierColumn("COLUMNNAME", false), SystemColumnImpl.getColumn("COLUMNNUMBER", 4, false), SystemColumnImpl.getJavaColumn("COLUMNDATATYPE", "org.apache.derby.catalog.TypeDescriptor", false), SystemColumnImpl.getJavaColumn("COLUMNDEFAULT", "java.io.Serializable", true), SystemColumnImpl.getUUIDColumn("COLUMNDEFAULTID", true), SystemColumnImpl.getColumn("AUTOINCREMENTVALUE", -5, true), SystemColumnImpl.getColumn("AUTOINCREMENTSTART", -5, true), SystemColumnImpl.getColumn("AUTOINCREMENTINC", -5, true), SystemColumnImpl.getColumn("AUTOINCREMENTCYCLE", 16, true)};
    }

    @Override
    public int getHeapColumnCount() throws StandardException {
        boolean bl = this.dataDictionary.checkVersion(260, null);
        int n = super.getHeapColumnCount();
        return bl ? n : n - 1;
    }
}

