/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.databaseaccess;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Array;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import org.eclipse.persistence.core.descriptors.CoreDescriptor;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.databaseaccess.BindCallCustomParameter;
import org.eclipse.persistence.internal.databaseaccess.DatabaseAccessor;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.internal.databaseaccess.DatasourceCall;
import org.eclipse.persistence.internal.databaseaccess.InOutputParameterForCallableStatement;
import org.eclipse.persistence.internal.databaseaccess.OutputParameterForCallableStatement;
import org.eclipse.persistence.internal.expressions.ParameterExpression;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.queries.CallQueryMechanism;
import org.eclipse.persistence.internal.queries.DatabaseQueryMechanism;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.structures.ObjectRelationalDataTypeDescriptor;
import org.eclipse.persistence.mappings.structures.ObjectRelationalDatabaseField;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ModifyQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.DatabaseRecord;

public abstract class DatabaseCall
extends DatasourceCall {
    protected boolean executeReturnValue;
    public static final DatabaseField MAXROW_FIELD = new DatabaseField("EclipseLink-MaxResults");
    public static final DatabaseField FIRSTRESULT_FIELD = new DatabaseField("EclipseLink-FirstRow");
    protected boolean ignoreFirstRowSetting;
    protected boolean ignoreMaxResultsSetting;
    protected transient Statement statement;
    protected transient ResultSet result;
    protected transient ResultSet generatedKeys;
    protected Boolean usesBinding;
    protected Boolean shouldCacheStatement;
    protected boolean shouldReturnGeneratedKeys;
    protected transient Vector<DatabaseField> fields;
    protected transient DatabaseField[] fieldsArray;
    protected boolean isFieldMatchingRequired;
    protected boolean hasOptimisticLock;
    protected boolean isResultSetScrollable;
    protected int resultSetFetchSize;
    protected int resultSetType;
    protected int resultSetConcurrency;
    protected int queryTimeout;
    protected TimeUnit queryTimeoutUnit;
    protected int maxRows;
    protected int firstResult;
    private transient AbstractRecord contexts;
    protected boolean isCursorOutputProcedure;
    protected boolean isMultipleCursorOutputProcedure;
    protected Boolean returnsResultSet;
    protected boolean shouldBuildOutputRow;
    protected boolean isCallableStatementRequired;
    protected boolean hasMultipleResultSets;
    protected boolean returnMultipleResultSetCollections;
    protected String sqlString;
    protected boolean hasAllocatedConnection;
    protected boolean isBatchExecutionSupported;

    protected DatabaseCall() {
        this.shouldProcessTokenInQuotes = false;
        this.shouldCacheStatement = null;
        this.isFieldMatchingRequired = false;
        this.queryTimeout = 0;
        this.queryTimeoutUnit = null;
        this.maxRows = 0;
        this.resultSetFetchSize = 0;
        this.isCursorOutputProcedure = false;
        this.shouldBuildOutputRow = false;
        this.returnsResultSet = null;
        this.isBatchExecutionSupported = true;
    }

    public boolean hasMultipleResultSets() {
        return this.hasMultipleResultSets;
    }

    public void setHasMultipleResultSets(boolean hasMultipleResultSets) {
        this.hasMultipleResultSets = hasMultipleResultSets;
    }

    @Override
    public void appendParameter(Writer writer, Object parameter, boolean shouldBind, AbstractSession session) {
        if (Boolean.TRUE.equals(shouldBind)) {
            this.bindParameter(writer, parameter);
        } else {
            session.getPlatform().appendParameter(this, writer, parameter);
        }
    }

    public void bindParameter(Writer writer, Object parameter) {
        if (parameter instanceof Collection) {
            throw QueryException.inCannotBeParameterized(this.getQuery());
        }
        try {
            writer.write("?");
        }
        catch (IOException exception) {
            throw ValidationException.fileError(exception);
        }
        this.getParameters().add(parameter);
    }

    @Override
    public DatabaseQueryMechanism buildNewQueryMechanism(DatabaseQuery query) {
        return new CallQueryMechanism(query, this);
    }

    public AbstractRecord buildOutputRow(CallableStatement statement, DatabaseAccessor accessor, AbstractSession session) throws SQLException {
        DatabaseRecord row = new DatabaseRecord();
        int size = this.parameters.size();
        for (int index = 0; index < size; ++index) {
            OutputParameterForCallableStatement outParameter;
            Object parameter = this.parameters.get(index);
            if (!(parameter instanceof OutputParameterForCallableStatement) || (outParameter = (OutputParameterForCallableStatement)parameter).isCursor() && this.isCursorOutputProcedure()) continue;
            Object value = this.getOutputParameterValue(statement, index, session);
            DatabaseField field = outParameter.getOutputField();
            if (value instanceof Struct) {
                CoreDescriptor descriptor = session.getDescriptor((Class)field.getType());
                if (descriptor != null && ((ClassDescriptor)descriptor).isObjectRelationalDataTypeDescriptor()) {
                    AbstractRecord nestedRow = ((ObjectRelationalDataTypeDescriptor)descriptor).buildRowFromStructure((Struct)value);
                    ReadObjectQuery query = new ReadObjectQuery();
                    query.setSession(session);
                    value = ((ClassDescriptor)descriptor).getObjectBuilder().buildNewInstance();
                    ((ClassDescriptor)descriptor).getObjectBuilder().buildAttributesIntoObject(value, null, nestedRow, query, null, null, false, this.getQuery().getSession());
                }
            } else if (value instanceof Array && field.isObjectRelationalDatabaseField()) {
                value = ObjectRelationalDataTypeDescriptor.buildContainerFromArray((Array)value, (ObjectRelationalDatabaseField)field, session);
            } else if (value instanceof ResultSet) {
                ResultSet resultSet = (ResultSet)value;
                this.setFields(null);
                this.matchFieldOrder(resultSet, accessor, session);
                value = accessor.processResultSet(resultSet, this, statement, session);
            }
            row.put(field, value);
        }
        return row;
    }

    @Override
    public DatabaseQueryMechanism buildQueryMechanism(DatabaseQuery query, DatabaseQueryMechanism mechanism) {
        if (mechanism.isCallQueryMechanism() && mechanism instanceof CallQueryMechanism) {
            CallQueryMechanism callMechanism = (CallQueryMechanism)mechanism;
            if (!callMechanism.hasMultipleCalls()) {
                callMechanism.addCall(callMechanism.getCall());
                callMechanism.setCall(null);
            }
            callMechanism.addCall(this);
            return mechanism;
        }
        return this.buildNewQueryMechanism(query);
    }

    @Override
    protected Object createInOutParameter(Object inValue, Object outParameter, AbstractSession session) {
        if (outParameter instanceof OutputParameterForCallableStatement) {
            return new InOutputParameterForCallableStatement(inValue, (OutputParameterForCallableStatement)outParameter);
        }
        if (outParameter instanceof DatabaseField) {
            return new InOutputParameterForCallableStatement(inValue, (DatabaseField)outParameter, session);
        }
        return null;
    }

    public String getCallString() {
        return this.getSQLString();
    }

    public Vector<DatabaseField> getFields() {
        return this.fields;
    }

    public DatabaseField[] getFieldsArray() {
        return this.fieldsArray;
    }

    protected DatabaseField getFieldWithTypeFromDescriptor(DatabaseField outField) {
        if (this.getQuery().getDescriptor() != null) {
            return this.getQuery().getDescriptor().getTypedField(outField);
        }
        return null;
    }

    public int getCursorOutIndex() {
        int size = this.getParameters().size();
        for (int i = 0; i < size; ++i) {
            Object parameter = this.parameters.get(i);
            if (!(parameter instanceof OutputParameterForCallableStatement) || !((OutputParameterForCallableStatement)parameter).isCursor()) continue;
            return i + 1;
        }
        return -1;
    }

    public boolean getExecuteReturnValue() {
        return this.executeReturnValue;
    }

    public int getFirstResult() {
        return this.firstResult;
    }

    @Override
    public String getLogString(Accessor accessor) {
        if (this.hasParameters()) {
            StringWriter writer = new StringWriter();
            writer.write(this.getSQLString());
            writer.write(Helper.cr());
            if (this.hasParameters()) {
                AbstractSession session = null;
                if (this.getQuery() != null) {
                    session = this.getQuery().getSession();
                }
                DatabaseCall.appendLogParameters(this.getParameters(), accessor, writer, session);
            }
            return writer.toString();
        }
        return this.getSQLString();
    }

    public static void appendLogParameters(Collection parameters, Accessor accessor, StringWriter writer, AbstractSession session) {
        writer.write("\tbind => [");
        if (session == null || session.shouldDisplayData()) {
            Iterator paramsEnum = parameters.iterator();
            while (paramsEnum.hasNext()) {
                Object parameter = paramsEnum.next();
                if (parameter instanceof DatabaseField) {
                    writer.write("null");
                } else {
                    if (session != null) {
                        parameter = session.getPlatform().convertToDatabaseType(parameter);
                    }
                    writer.write(String.valueOf(parameter));
                }
                if (paramsEnum.hasNext()) {
                    writer.write(", ");
                    continue;
                }
                writer.write("]");
            }
        } else {
            String parameterString = parameters.size() == 1 ? " parameter" : " parameters";
            writer.write(parameters.size() + parameterString + " bound]");
        }
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public Vector getOutputRowFields() {
        Vector<Object> fields = new Vector<Object>();
        int size = this.getParameters().size();
        for (int i = 0; i < size; ++i) {
            Object parameter = this.parameters.get(i);
            DatasourceCall.ParameterType parameterType = (DatasourceCall.ParameterType)((Object)this.parameterTypes.get(i));
            if (parameterType == DatasourceCall.ParameterType.OUT) {
                fields.add(parameter);
                continue;
            }
            if (parameterType != DatasourceCall.ParameterType.INOUT) continue;
            fields.add(((Object[])parameter)[1]);
        }
        return fields;
    }

    @Override
    public String getQueryString() {
        return this.getSQLString();
    }

    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    public ResultSet getGeneratedKeys() {
        return this.generatedKeys;
    }

    public ResultSet getResult() {
        return this.result;
    }

    public boolean getReturnsResultSet() {
        if (this.returnsResultSet == null) {
            return !this.shouldBuildOutputRow();
        }
        return this.returnsResultSet;
    }

    public int getResultSetConcurrency() {
        return this.resultSetConcurrency;
    }

    public int getResultSetFetchSize() {
        return this.resultSetFetchSize;
    }

    public int getResultSetType() {
        return this.resultSetType;
    }

    public String getSQLString() {
        return this.sqlString;
    }

    public Statement getStatement() {
        return this.statement;
    }

    public boolean hasOptimisticLock() {
        return this.hasOptimisticLock;
    }

    protected boolean isCallableStatementRequired() {
        return this.isCallableStatementRequired;
    }

    protected boolean isDynamicCall(AbstractSession session) {
        return DatabaseAccessor.shouldUseDynamicStatements && !this.usesBinding(session) && !this.isResultSetScrollable() && !this.hasParameters();
    }

    public boolean isCursorOutputProcedure() {
        return this.isCursorOutputProcedure;
    }

    @Override
    public boolean isCursorReturned() {
        return this.returnType == 4;
    }

    public boolean isFieldMatchingRequired() {
        return this.isFieldMatchingRequired;
    }

    @Override
    public boolean isFinished() {
        return !this.isCursorReturned() && !this.isExecuteUpdate();
    }

    public boolean isMultipleCursorOutputProcedure() {
        return this.isMultipleCursorOutputProcedure;
    }

    public boolean isNonCursorOutputProcedure() {
        return !this.isCursorOutputProcedure() && this.shouldBuildOutputRow();
    }

    public boolean isResultSetScrollable() {
        return this.isResultSetScrollable;
    }

    public void matchFieldOrder(ResultSet resultSet, DatabaseAccessor accessor, AbstractSession session) {
        if (this.getFields() != null && !this.isFieldMatchingRequired()) {
            return;
        }
        this.setFields(accessor.buildSortedFields(this.getFields(), resultSet, session));
    }

    @Override
    public void prepare(AbstractSession session) {
        if (this.isPrepared) {
            return;
        }
        this.prepareInternal(session);
        this.isPrepared = true;
    }

    protected void prepareInternal(AbstractSession session) {
        this.prepareInternalParameters(session);
    }

    protected void prepareInternalParameters(AbstractSession session) {
        if (this.isCursorOutputProcedure()) {
            int nFirstOutParameterIndex = -1;
            boolean hasFoundOutCursor = false;
            int size = this.parameters.size();
            for (int index = 0; index < size; ++index) {
                DatasourceCall.ParameterType parameterType = (DatasourceCall.ParameterType)((Object)this.parameterTypes.get(index));
                if (parameterType == DatasourceCall.ParameterType.OUT_CURSOR) {
                    if (hasFoundOutCursor) {
                        throw ValidationException.multipleCursorsNotSupported(this.toString());
                    }
                    hasFoundOutCursor = true;
                    continue;
                }
                if (parameterType == DatasourceCall.ParameterType.OUT) {
                    if (nFirstOutParameterIndex != -1) continue;
                    nFirstOutParameterIndex = index;
                    continue;
                }
                if (parameterType != null) continue;
                throw ValidationException.wrongUsageOfSetCustomArgumentTypeMethod(this.toString());
            }
            if (!hasFoundOutCursor && nFirstOutParameterIndex >= 0) {
                this.parameterTypes.set(nFirstOutParameterIndex, DatasourceCall.ParameterType.OUT_CURSOR);
            }
        }
        int size = this.getParameters().size();
        block6: for (int i = 0; i < size; ++i) {
            Object parameterValue = this.parameters.get(i);
            DatasourceCall.ParameterType parameterType = (DatasourceCall.ParameterType)((Object)this.parameterTypes.get(i));
            switch (parameterType) {
                case MODIFY: {
                    DatabaseField field = (DatabaseField)parameterValue;
                    if (field.getType() != null && !session.getPlatform().shouldUseCustomModifyForCall(field)) continue block6;
                    this.parameterTypes.set(i, DatasourceCall.ParameterType.CUSTOM_MODIFY);
                    continue block6;
                }
                case INOUT: {
                    DatabaseField typeOutField;
                    this.setShouldBuildOutputRow(true);
                    this.setIsCallableStatementRequired(true);
                    DatabaseField outField = (DatabaseField)((Object[])parameterValue)[1];
                    if (outField.getType() == null && (typeOutField = this.getFieldWithTypeFromDescriptor(outField)) != null) {
                        outField = typeOutField.clone();
                    }
                    if (outField.getType() == null) continue block6;
                    OutputParameterForCallableStatement outParameter = new OutputParameterForCallableStatement(outField, session);
                    ((Object[])parameterValue)[1] = outParameter;
                    continue block6;
                }
                case OUT: 
                case OUT_CURSOR: {
                    DatabaseField typeOutField;
                    boolean isCursor;
                    boolean bl = isCursor = parameterType == DatasourceCall.ParameterType.OUT_CURSOR;
                    if (!isCursor) {
                        this.setShouldBuildOutputRow(true);
                    }
                    this.setIsCallableStatementRequired(true);
                    DatabaseField outField = (DatabaseField)parameterValue;
                    if (outField.getType() == null && (typeOutField = this.getFieldWithTypeFromDescriptor(outField)) != null) {
                        outField = typeOutField.clone();
                    }
                    OutputParameterForCallableStatement outParameter = new OutputParameterForCallableStatement(outField, session, isCursor);
                    this.parameters.set(i, outParameter);
                    this.parameterTypes.set(i, parameterType);
                }
            }
        }
        if (this.returnsResultSet == null) {
            this.setReturnsResultSet(!this.isCallableStatementRequired());
        }
        this.isBatchExecutionSupported = !(!this.isNothingReturned() || this.hasOptimisticLock() && !session.getPlatform().canBatchWriteWithOptimisticLocking(this) || this.shouldBuildOutputRow() || this.shouldReturnGeneratedKeys() || !session.getPlatform().usesJDBCBatchWriting() && this.hasParameters() || this.isLOBLocatorNeeded() || !this.getQuery().isModifyQuery() || !((ModifyQuery)this.getQuery()).isBatchExecutionSupported());
    }

    public Statement prepareStatement(DatabaseAccessor accessor, AbstractRecord translationRow, AbstractSession session) throws SQLException {
        Statement statement = accessor.prepareStatement(this, session);
        if (this.queryTimeout > 0 && this.queryTimeoutUnit != null) {
            long timeout = TimeUnit.SECONDS.convert(this.queryTimeout, this.queryTimeoutUnit);
            if (timeout > Integer.MAX_VALUE) {
                timeout = Integer.MAX_VALUE;
            }
            if (TimeUnit.SECONDS.compareTo(this.queryTimeoutUnit) > 0 && this.queryTimeout % 1000 > 0) {
                ++timeout;
            }
            statement.setQueryTimeout((int)timeout);
        }
        if (!this.ignoreMaxResultsSetting && this.maxRows > 0) {
            statement.setMaxRows(this.maxRows);
        }
        if (this.resultSetFetchSize > 0) {
            statement.setFetchSize(this.resultSetFetchSize);
        }
        if (this.parameters == null) {
            return statement;
        }
        List parameters = this.getParameters();
        int size = parameters.size();
        for (int index = 0; index < size; ++index) {
            session.getPlatform().setParameterValueInDatabaseCall(parameters.get(index), (PreparedStatement)statement, index + 1, session);
        }
        return statement;
    }

    public boolean returnMultipleResultSetCollections() {
        return this.returnMultipleResultSetCollections;
    }

    public void setFields(Vector<DatabaseField> fields) {
        this.fields = fields;
        if (fields != null) {
            int size = fields.size();
            this.fieldsArray = new DatabaseField[size];
            for (int index = 0; index < size; ++index) {
                this.fieldsArray[index] = fields.get(index);
            }
        } else {
            this.fieldsArray = null;
        }
    }

    public void setFirstResult(int firstResult) {
        this.firstResult = firstResult;
    }

    public void setHasOptimisticLock(boolean hasOptimisticLock) {
        this.hasOptimisticLock = hasOptimisticLock;
    }

    public void setIgnoreFirstRowSetting(boolean ignoreFirstRowSetting) {
        this.ignoreFirstRowSetting = ignoreFirstRowSetting;
    }

    public void setIgnoreMaxResultsSetting(boolean ignoreMaxResultsSetting) {
        this.ignoreMaxResultsSetting = ignoreMaxResultsSetting;
    }

    public boolean setShouldReturnGeneratedKeys(boolean shouldReturnGeneratedKeys) {
        this.shouldReturnGeneratedKeys = shouldReturnGeneratedKeys;
        return this.shouldReturnGeneratedKeys;
    }

    protected void setIsCallableStatementRequired(boolean isCallableStatementRequired) {
        this.isCallableStatementRequired = isCallableStatementRequired;
    }

    public void setIsCursorOutputProcedure(boolean isCursorOutputProcedure) {
        this.isCursorOutputProcedure = isCursorOutputProcedure;
    }

    public void setIsFieldMatchingRequired(boolean isFieldMatchingRequired) {
        this.isFieldMatchingRequired = isFieldMatchingRequired;
    }

    public void setIsMultipleCursorOutputProcedure(boolean isMultipleCursorOutputProcedure) {
        this.isMultipleCursorOutputProcedure = isMultipleCursorOutputProcedure;
    }

    public void setIsResultSetScrollable(boolean isResultSetScrollable) {
        this.isResultSetScrollable = isResultSetScrollable;
    }

    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    @Override
    public void setQueryString(String queryString) {
        this.setSQLStringInternal(queryString);
    }

    public void setQueryTimeout(int queryTimeout) {
        this.queryTimeout = queryTimeout;
    }

    public void setQueryTimeoutUnit(TimeUnit queryTimeoutUnit) {
        this.queryTimeoutUnit = queryTimeoutUnit;
    }

    public void setGeneratedKeys(ResultSet generatedKeys) {
        this.generatedKeys = generatedKeys;
    }

    public void setResult(ResultSet result) {
        this.result = result;
    }

    public void setResultSetConcurrency(int resultSetConcurrency) {
        this.resultSetConcurrency = resultSetConcurrency;
    }

    protected void setSQLStringInternal(String sqlString) {
        this.sqlString = sqlString;
    }

    public void setResultSetFetchSize(int resultSetFetchSize) {
        this.resultSetFetchSize = resultSetFetchSize;
    }

    public void setResultSetType(int resultSetType) {
        this.resultSetType = resultSetType;
    }

    public void setReturnsResultSet(boolean returnsResultSet) {
        this.returnsResultSet = returnsResultSet;
    }

    public void setReturnMultipleResultSetCollections(boolean returnMultipleResultSetCollections) {
        this.returnMultipleResultSetCollections = returnMultipleResultSetCollections;
    }

    protected void setShouldBuildOutputRow(boolean shouldBuildOutputRow) {
        this.shouldBuildOutputRow = shouldBuildOutputRow;
    }

    public void setShouldCacheStatement(boolean shouldCacheStatement) {
        this.shouldCacheStatement = shouldCacheStatement;
    }

    public void setStatement(Statement statement) {
        this.statement = statement;
    }

    public boolean shouldBuildOutputRow() {
        return this.shouldBuildOutputRow;
    }

    public boolean shouldCacheStatement(AbstractSession session) {
        return this.shouldCacheStatement(session.getPlatform());
    }

    public boolean shouldCacheStatement(DatabasePlatform databasePlatform) {
        if (this.isResultSetScrollable()) {
            return false;
        }
        if (this.shouldCacheStatement == null) {
            return databasePlatform.shouldCacheAllStatements();
        }
        return this.shouldCacheStatement;
    }

    public boolean shouldIgnoreFirstRowSetting() {
        return this.ignoreFirstRowSetting;
    }

    public boolean shouldIgnoreMaxResultsSetting() {
        return this.ignoreMaxResultsSetting;
    }

    public boolean shouldReturnGeneratedKeys() {
        return this.shouldReturnGeneratedKeys;
    }

    public String toString() {
        String str = Helper.getShortClassName(this.getClass());
        if (this.getSQLString() == null) {
            return str;
        }
        return str + "(" + this.getSQLString() + ")";
    }

    @Override
    public void translate(AbstractRecord translationRow, AbstractRecord modifyRow, AbstractSession session) {
        if (!this.isPrepared()) {
            throw ValidationException.cannotTranslateUnpreparedCall(this.toString());
        }
        if (session.getPlatform().shouldBindPartialParameters() && this.parameters != null) {
            this.translateQueryStringAndBindParameters(translationRow, modifyRow, session);
        } else if (this.usesBinding(session) && this.parameters != null) {
            boolean hasParameterizedIN = false;
            List parameters = this.getParameters();
            int size = parameters.size();
            ArrayList<Object> translatedParametersValues = new ArrayList<Object>(size);
            block9: for (int index = 0; index < size; ++index) {
                Object parameter = parameters.get(index);
                DatasourceCall.ParameterType parameterType = (DatasourceCall.ParameterType)((Object)this.parameterTypes.get(index));
                DatabaseField field = null;
                Object translatedValue = null;
                switch (parameterType) {
                    case MODIFY: {
                        field = (DatabaseField)parameter;
                        translatedValue = modifyRow.get(field);
                        if (translatedValue == null && (translatedValue = modifyRow.getField(field)) == null) {
                            translatedValue = field;
                        }
                        translatedParametersValues.add(translatedValue);
                        continue block9;
                    }
                    case CUSTOM_MODIFY: {
                        field = (DatabaseField)parameter;
                        translatedValue = modifyRow.get(field);
                        translatedValue = session.getPlatform().getCustomModifyValueForCall(this, translatedValue, field, true);
                        if (translatedValue != null && translatedValue instanceof BindCallCustomParameter && ((BindCallCustomParameter)translatedValue).shouldUseUnwrappedConnection()) {
                            this.isNativeConnectionRequired = true;
                        }
                        if (translatedValue == null && (translatedValue = modifyRow.getField(field)) == null) {
                            translatedValue = field;
                        }
                        translatedParametersValues.add(translatedValue);
                        continue block9;
                    }
                    case TRANSLATION: {
                        if (parameter instanceof ParameterExpression) {
                            field = ((ParameterExpression)parameter).getField();
                            translatedValue = ((ParameterExpression)parameter).getValue(translationRow, this.query, session);
                        } else {
                            field = (DatabaseField)parameter;
                            translatedValue = translationRow.get(field);
                            if (translatedValue == null) {
                                translatedValue = modifyRow.get(field);
                            }
                        }
                        if (translatedValue instanceof Collection) {
                            hasParameterizedIN = true;
                        }
                        if (translatedValue == null && field != null) {
                            if (this.query.hasNullableArguments() && this.query.getNullableArguments().contains(field)) continue block9;
                            translatedValue = translationRow.getField(field);
                            if (translatedValue == null) {
                                translatedValue = field;
                            }
                            translatedParametersValues.add(translatedValue);
                            continue block9;
                        }
                        translatedParametersValues.add(translatedValue);
                        continue block9;
                    }
                    case LITERAL: {
                        translatedParametersValues.add(parameter);
                        continue block9;
                    }
                    case IN: {
                        translatedValue = this.getValueForInParameter(parameter, translationRow, modifyRow, session, true);
                        if (translatedValue == this) continue block9;
                        translatedParametersValues.add(translatedValue);
                        continue block9;
                    }
                    case INOUT: {
                        translatedValue = this.getValueForInOutParameter(parameter, translationRow, modifyRow, session);
                        translatedParametersValues.add(translatedValue);
                        continue block9;
                    }
                    case OUT: 
                    case OUT_CURSOR: {
                        if (parameter != null) {
                            ((OutputParameterForCallableStatement)parameter).getOutputField().setIndex(index);
                        }
                        translatedParametersValues.add(parameter);
                    }
                }
            }
            this.setParameters(translatedParametersValues);
            if (hasParameterizedIN) {
                this.translateQueryStringForParameterizedIN(translationRow, modifyRow, session);
            }
        } else {
            this.translateQueryString(translationRow, modifyRow, session);
        }
    }

    public boolean isLOBLocatorNeeded() {
        return this.contexts != null;
    }

    public void addContext(DatabaseField field, Object value) {
        if (this.contexts == null) {
            this.contexts = new DatabaseRecord(2);
        }
        this.contexts.add(field, value);
        this.isBatchExecutionSupported = false;
    }

    public AbstractRecord getContexts() {
        return this.contexts;
    }

    public void setContexts(AbstractRecord contexts) {
        this.contexts = contexts;
    }

    public void setExecuteReturnValue(boolean value) {
        this.executeReturnValue = value;
    }

    public void useUnnamedCursorOutputAsResultSet() {
        this.setIsCursorOutputProcedure(true);
    }

    public boolean isBatchExecutionSupported() {
        return this.isBatchExecutionSupported;
    }

    public void setBatchExecutionSupported(boolean isBatchExecutionSupported) {
        this.isBatchExecutionSupported = isBatchExecutionSupported;
    }

    public boolean hasAllocatedConnection() {
        return this.hasAllocatedConnection;
    }

    public void setHasAllocatedConnection(boolean hasAllocatedConnection) {
        this.hasAllocatedConnection = hasAllocatedConnection;
    }

    public Object getOutputParameterValue(CallableStatement statement, int index, AbstractSession session) throws SQLException {
        return session.getPlatform().getParameterValueFromDatabaseCall(statement, index + 1, session);
    }

    public Object getOutputParameterValue(CallableStatement statement, String name, AbstractSession session) throws SQLException {
        return session.getPlatform().getParameterValueFromDatabaseCall(statement, name, session);
    }
}

