/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types.resources;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.BaseResourceCollectionContainer;

public class Union
extends BaseResourceCollectionContainer {
    public static Union getInstance(ResourceCollection rc) {
        return rc instanceof Union ? (Union)rc : new Union(rc);
    }

    public Union() {
    }

    public Union(Project project) {
        super(project);
    }

    public Union(ResourceCollection rc) {
        this(Project.getProject(rc), rc);
    }

    public Union(Project project, ResourceCollection rc) {
        super(project);
        this.add(rc);
    }

    public String[] list() {
        if (this.isReference()) {
            return this.getCheckedRef(Union.class, this.getDataTypeName()).list();
        }
        Collection<String> result = this.getAllToStrings();
        return result.toArray(new String[result.size()]);
    }

    public Resource[] listResources() {
        if (this.isReference()) {
            return this.getCheckedRef(Union.class, this.getDataTypeName()).listResources();
        }
        Set<Resource> result = this.getAllResources();
        return result.toArray(new Resource[result.size()]);
    }

    @Override
    protected Collection<Resource> getCollection() {
        return this.getAllResources();
    }

    @Deprecated
    protected <T> Collection<T> getCollection(boolean asString) {
        return asString ? this.getAllToStrings() : this.getAllResources();
    }

    protected Collection<String> getAllToStrings() {
        Set<Resource> allResources = this.getAllResources();
        ArrayList<String> result = new ArrayList<String>(allResources.size());
        for (Resource r : allResources) {
            result.add(r.toString());
        }
        return result;
    }

    protected Set<Resource> getAllResources() {
        List<ResourceCollection> resourceCollections = this.getResourceCollections();
        if (resourceCollections.isEmpty()) {
            return Collections.emptySet();
        }
        LinkedHashSet<Resource> result = new LinkedHashSet<Resource>(resourceCollections.size() * 2);
        for (ResourceCollection resourceCollection : resourceCollections) {
            for (Resource r : resourceCollection) {
                result.add(r);
            }
        }
        return result;
    }
}

