/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import org.apache.catalina.Authenticator;
import org.apache.catalina.Connector;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Loader;
import org.apache.catalina.LogFacade;
import org.apache.catalina.Logger;
import org.apache.catalina.Realm;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardEngine;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.core.StandardService;
import org.apache.catalina.loader.WebappLoader;
import org.apache.catalina.net.ServerSocketFactory;
import org.apache.catalina.security.SecurityConfig;
import org.apache.catalina.startup.ContextConfig;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.util.ServerInfo;
import org.glassfish.web.util.IntrospectionUtils;
import org.glassfish.web.valve.GlassFishValve;

public class Embedded
extends StandardService {
    protected static final java.util.logging.Logger log = LogFacade.getLogger();
    protected static final ResourceBundle rb = log.getResourceBundle();
    protected boolean useNaming = true;
    protected Engine[] engines = new Engine[0];
    protected HashMap<String, Authenticator> authenticators;
    protected static final String info = "org.apache.catalina.startup.Embedded/1.0";
    protected LifecycleSupport lifecycle = new LifecycleSupport(this);
    protected Logger logger = null;
    protected Realm realm = null;
    protected String socketFactory = "org.apache.catalina.net.SSLSocketFactory";
    protected boolean started = false;
    protected boolean await = false;
    protected boolean embeddedDirectoryListing = false;

    public Embedded() {
        this(null, null);
    }

    public Embedded(Logger logger, Realm realm) {
        this.setLogger(logger);
        this.setRealm(realm);
        this.setSecurityProtection();
    }

    public boolean isUseNaming() {
        return this.useNaming;
    }

    public void setUseNaming(boolean useNaming) {
        boolean oldUseNaming = this.useNaming;
        this.useNaming = useNaming;
        this.support.firePropertyChange("useNaming", (Object)oldUseNaming, (Object)this.useNaming);
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        Logger oldLogger = this.logger;
        this.logger = logger;
        this.support.firePropertyChange("logger", oldLogger, this.logger);
    }

    public Realm getRealm() {
        return this.realm;
    }

    public void setRealm(Realm realm) {
        Realm oldRealm = this.realm;
        this.realm = realm;
        this.support.firePropertyChange("realm", oldRealm, this.realm);
    }

    public String getSocketFactory() {
        return this.socketFactory;
    }

    public void setSocketFactory(String socketFactory) {
        this.socketFactory = socketFactory;
    }

    public void setAwait(boolean b) {
        this.await = b;
    }

    public boolean isAwait() {
        return this.await;
    }

    public void setCatalinaHome(String s) {
        System.setProperty("catalina.home", s);
    }

    public void setCatalinaBase(String s) {
        System.setProperty("catalina.base", s);
    }

    public String getCatalinaHome() {
        return System.getProperty("catalina.home");
    }

    public String getCatalinaBase() {
        return System.getProperty("catalina.base");
    }

    public void setDirectoryListing(boolean listings) {
        this.embeddedDirectoryListing = listings;
    }

    public boolean isDirectoryListing() {
        return this.embeddedDirectoryListing;
    }

    @Override
    public synchronized void addConnector(Connector connector) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Adding connector (" + connector.getInfo() + ")");
        }
        if (this.engines.length < 1) {
            throw new IllegalStateException(rb.getString("AS-WEB-CORE-00431"));
        }
        super.addConnector(connector);
    }

    public synchronized void addEngine(Engine engine) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Adding engine (" + engine.getInfo() + ")");
        }
        Engine[] results = new Engine[this.engines.length + 1];
        for (int i = 0; i < this.engines.length; ++i) {
            results[i] = this.engines[i];
        }
        results[this.engines.length] = engine;
        this.engines = results;
        if (this.started && engine instanceof Lifecycle) {
            try {
                ((Lifecycle)((Object)engine)).start();
            }
            catch (LifecycleException e) {
                log.log(Level.SEVERE, "AS-WEB-CORE-00432", e);
            }
        }
        this.container = engine;
    }

    public Engine[] getEngines() {
        return this.engines;
    }

    public Connector createConnector(InetAddress address, int port, boolean secure) {
        return this.createConnector(address != null ? address.toString() : null, port, secure);
    }

    public Connector createConnector(String address, int port, boolean secure) {
        String protocol = "http";
        if (secure) {
            protocol = "https";
        }
        return this.createConnector(address, port, protocol);
    }

    public Connector createConnector(InetAddress address, int port, String protocol) {
        return this.createConnector(address != null ? address.toString() : null, port, protocol);
    }

    public Connector createConnector(String address, int port, String protocol) {
        int index;
        Connector connector = null;
        if (address != null && (index = address.indexOf(47)) != -1) {
            address = address.substring(index + 1);
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Creating connector for address='" + (address == null ? "ALL" : address) + "' port='" + port + "' protocol='" + protocol + "'");
        }
        try {
            Class<?> clazz = Class.forName("org.apache.catalina.connector.Connector");
            connector = (Connector)clazz.newInstance();
            if (address != null) {
                IntrospectionUtils.setProperty((Object)connector, (String)"address", (String)address);
            }
            IntrospectionUtils.setProperty((Object)connector, (String)"port", (String)("" + port));
            if (protocol.equals("ajp")) {
                IntrospectionUtils.setProperty((Object)connector, (String)"protocolHandlerClassName", (String)"org.apache.jk.server.JkCoyoteHandler");
            } else if (protocol.equals("https")) {
                connector.setScheme("https");
                connector.setSecure(true);
                try {
                    Class<?> serverSocketFactoryClass = Class.forName("org.apache.catalina.connector.CoyoteServerSocketFactory");
                    ServerSocketFactory factory = (ServerSocketFactory)serverSocketFactoryClass.newInstance();
                    connector.setFactory(factory);
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "AS-WEB-CORE-00433");
                }
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "AS-WEB-CORE-00434");
        }
        return connector;
    }

    public Context createContext(String path, String docBase) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Creating context '" + path + "' with docBase '" + docBase + "'");
        }
        StandardContext context = new StandardContext();
        context.setDebug(this.debug);
        context.setDocBase(docBase);
        context.setPath(path);
        ContextConfig config = new ContextConfig();
        config.setCustomAuthenticators(this.authenticators);
        config.setDebug(this.debug);
        context.addLifecycleListener(config);
        return context;
    }

    public Engine createEngine() {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Creating engine");
        }
        StandardEngine engine = new StandardEngine();
        engine.setDebug(this.debug);
        engine.setLogger(this.logger);
        engine.setRealm(this.realm);
        return engine;
    }

    public Host createHost(String name, String appBase) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Creating host '" + name + "' with appBase '" + appBase + "'");
        }
        StandardHost host = new StandardHost();
        host.setAppBase(appBase);
        host.setDebug(this.debug);
        host.setName(name);
        return host;
    }

    public Loader createLoader(ClassLoader parent) {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Creating Loader with parent class loader '" + String.valueOf(parent) + "'");
        }
        WebappLoader loader = new WebappLoader(parent);
        return loader;
    }

    @Override
    public String getInfo() {
        return info;
    }

    public synchronized void removeContext(Context context) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Removing context[" + context.getPath() + "]");
        }
        boolean found = false;
        for (int i = 0; i < this.engines.length; ++i) {
            Container[] hosts = this.engines[i].findChildren();
            for (int j = 0; j < hosts.length; ++j) {
                Container[] contexts = hosts[j].findChildren();
                for (int k = 0; k < contexts.length; ++k) {
                    if (context != (Context)contexts[k]) continue;
                    found = true;
                    break;
                }
                if (found) break;
            }
            if (found) break;
        }
        if (!found) {
            return;
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, " Removing this Context");
        }
        context.getParent().removeChild(context);
    }

    public synchronized void removeEngine(Engine engine) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Removing engine (" + engine.getInfo() + ")");
        }
        int j = -1;
        for (int i = 0; i < this.engines.length; ++i) {
            if (engine != this.engines[i]) continue;
            j = i;
            break;
        }
        if (j < 0) {
            return;
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, " Removing related Containers");
        }
        while (true) {
            int n = -1;
            for (int i = 0; i < this.connectors.length; ++i) {
                if (this.connectors[i].getContainer() != engine) continue;
                n = i;
                break;
            }
            if (n < 0) break;
            try {
                this.removeConnector(this.connectors[n]);
            }
            catch (Exception ex) {
                log.log(Level.SEVERE, "AS-WEB-CORE-00435", ex);
            }
        }
        if (engine instanceof Lifecycle) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, " Stopping this Engine");
            }
            try {
                ((Lifecycle)((Object)engine)).stop();
            }
            catch (LifecycleException e) {
                log.log(Level.SEVERE, "AS-WEB-CORE-00436", e);
            }
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, " Removing this Engine");
        }
        int k = 0;
        Engine[] results = new Engine[this.engines.length - 1];
        for (int i = 0; i < this.engines.length; ++i) {
            if (i == j) continue;
            results[k++] = this.engines[i];
        }
        this.engines = results;
    }

    public synchronized void removeHost(Host host) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Removing host[" + host.getName() + "]");
        }
        boolean found = false;
        for (int i = 0; i < this.engines.length; ++i) {
            Container[] hosts = this.engines[i].findChildren();
            for (int j = 0; j < hosts.length; ++j) {
                if (host != (Host)hosts[j]) continue;
                found = true;
                break;
            }
            if (found) break;
        }
        if (!found) {
            return;
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, " Removing this Host");
        }
        host.getParent().removeChild(host);
    }

    public synchronized void addAuthenticator(Authenticator authenticator, String loginMethod) {
        if (authenticator != null && !(authenticator instanceof GlassFishValve)) {
            throw new IllegalArgumentException(rb.getString("AS-WEB-CORE-00437"));
        }
        if (this.authenticators == null) {
            this.authenticators = new HashMap();
        }
        this.authenticators.put(loginMethod, authenticator);
    }

    @Override
    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    @Override
    public List<LifecycleListener> findLifecycleListeners() {
        return this.lifecycle.findLifecycleListeners();
    }

    @Override
    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    @Override
    public void start() throws LifecycleException {
        int i;
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Starting Servlet container component of " + ServerInfo.getServerInfo());
        }
        this.initDirs();
        this.initNaming();
        if (this.started) {
            throw new LifecycleException(rb.getString("AS-WEB-CORE-00438"));
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
        this.initialized = true;
        for (i = 0; i < this.connectors.length; ++i) {
            this.connectors[i].initialize();
            if (!(this.connectors[i] instanceof Lifecycle)) continue;
            ((Lifecycle)((Object)this.connectors[i])).start();
        }
        for (i = 0; i < this.engines.length; ++i) {
            if (!(this.engines[i] instanceof Lifecycle)) continue;
            ((Lifecycle)((Object)this.engines[i])).start();
        }
    }

    @Override
    public void stop() throws LifecycleException {
        int i;
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Stopping embedded server");
        }
        if (!this.started) {
            throw new LifecycleException(rb.getString("AS-WEB-CORE-00439"));
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
        for (i = 0; i < this.connectors.length; ++i) {
            if (!(this.connectors[i] instanceof Lifecycle)) continue;
            ((Lifecycle)((Object)this.connectors[i])).stop();
        }
        for (i = 0; i < this.engines.length; ++i) {
            if (!(this.engines[i] instanceof Lifecycle)) continue;
            ((Lifecycle)((Object)this.engines[i])).stop();
        }
    }

    @Override
    public void destroy() throws LifecycleException {
        if (this.started) {
            this.stop();
        }
        if (this.initialized) {
            this.initialized = false;
        }
    }

    protected void initNaming() {
        if (!this.useNaming) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Catalina naming disabled");
            }
            System.setProperty("catalina.useNaming", "false");
        } else {
            System.setProperty("catalina.useNaming", "true");
            Object value = "org.apache.naming";
            String oldValue = System.getProperty("java.naming.factory.url.pkgs");
            if (oldValue != null) {
                value = (String)value + ":" + oldValue;
            }
            System.setProperty("java.naming.factory.url.pkgs", (String)value);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Setting naming prefix=" + (String)value);
            }
            if ((value = System.getProperty("java.naming.factory.initial")) == null) {
                System.setProperty("java.naming.factory.initial", "org.apache.naming.java.javaURLContextFactory");
            } else if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "INITIAL_CONTEXT_FACTORY alread set " + (String)value);
            }
        }
    }

    protected void initDirs() {
        String catalinaHome = System.getProperty("catalina.home");
        if (catalinaHome == null) {
            String j2eeHome = System.getProperty("com.sun.enterprise.home");
            if (j2eeHome != null) {
                catalinaHome = System.getProperty("com.sun.enterprise.home");
            } else if (System.getProperty("catalina.base") != null) {
                catalinaHome = System.getProperty("catalina.base");
            } else {
                catalinaHome = IntrospectionUtils.guessInstall((String)"catalina.home", (String)"catalina.base", (String)"catalina.jar");
                if (catalinaHome == null) {
                    catalinaHome = IntrospectionUtils.guessInstall((String)"tomcat.install", (String)"catalina.home", (String)"tomcat.jar");
                }
            }
        }
        if (catalinaHome == null) {
            catalinaHome = System.getProperty("user.dir");
        }
        if (catalinaHome != null) {
            File home = new File(catalinaHome);
            if (!home.isAbsolute()) {
                try {
                    catalinaHome = home.getCanonicalPath();
                }
                catch (IOException e) {
                    catalinaHome = home.getAbsolutePath();
                }
            }
            System.setProperty("catalina.home", catalinaHome);
        }
        if (System.getProperty("catalina.base") == null) {
            System.setProperty("catalina.base", catalinaHome);
        } else {
            String catalinaBase = System.getProperty("catalina.base");
            File base = new File(catalinaBase);
            if (!base.isAbsolute()) {
                try {
                    catalinaBase = base.getCanonicalPath();
                }
                catch (IOException e) {
                    catalinaBase = base.getAbsolutePath();
                }
            }
            System.setProperty("catalina.base", catalinaBase);
        }
    }

    protected void setSecurityProtection() {
        if (System.getSecurityManager() != null) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    SecurityConfig securityConfig = SecurityConfig.newInstance();
                    securityConfig.setPackageDefinition();
                    securityConfig.setPackageAccess();
                    return null;
                }
            });
        }
    }
}

