/*
 * Decompiled with CFR 0.152.
 */
package com.sun.data.provider.impl;

import com.sun.data.provider.DataProviderException;
import com.sun.data.provider.FieldKey;
import com.sun.data.provider.FilterCriteria;
import com.sun.data.provider.RowKey;
import com.sun.data.provider.TableDataProvider;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class RegexFilterCriteria
extends FilterCriteria {
    private transient ResourceBundle bundle = null;
    private FieldKey fieldKey;
    protected Pattern pattern;

    public RegexFilterCriteria() {
    }

    private ResourceBundle getBundle() {
        if (this.bundle == null) {
            this.bundle = ResourceBundle.getBundle("com/sun/data/provider/impl/Bundle");
        }
        return this.bundle;
    }

    public RegexFilterCriteria(FieldKey fieldKey) {
        this.fieldKey = fieldKey;
    }

    public RegexFilterCriteria(String expression) throws PatternSyntaxException {
        this.setExpression(expression);
    }

    public RegexFilterCriteria(FieldKey fieldKey, String expression) throws PatternSyntaxException {
        this.fieldKey = fieldKey;
        this.setExpression(expression);
    }

    public String getDisplayName() {
        String name = super.getDisplayName();
        if (name != null && !"".equals(name)) {
            return name;
        }
        FieldKey key = this.getFieldKey();
        String expr = this.getExpression();
        return (this.isInclude() ? this.getBundle().getString("INCLUDE") + " [" : this.getBundle().getString("EXCLUDE") + " [") + (key != null ? key.getDisplayName() : this.getBundle().getString("NO_DATA_KEY")) + "] " + this.getBundle().getString("REGULAR_EXPRESSION_MATCH") + (expr != null ? "\"" + this.getExpression() + "\"" : this.getBundle().getString("NO_EXPRESSION"));
    }

    public void setFieldKey(FieldKey fieldKey) {
        this.fieldKey = fieldKey;
    }

    public FieldKey getFieldKey() {
        return this.fieldKey;
    }

    public void setExpression(String expression) throws PatternSyntaxException {
        this.pattern = Pattern.compile(expression);
    }

    public String getExpression() {
        return this.pattern != null ? this.pattern.pattern() : null;
    }

    public boolean match(TableDataProvider provider, RowKey row) throws DataProviderException {
        if (this.fieldKey == null || this.pattern == null) {
            return this.isInclude();
        }
        Object o = provider.getValue(this.fieldKey, row);
        if (o == null) {
            return !this.isInclude();
        }
        try {
            return this.pattern.matcher(o.toString()).matches();
        }
        catch (Exception x) {
            return false;
        }
    }
}

