/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.model.scheduler;

import com.sun.webui.jsf.util.LogUtil;
import com.sun.webui.jsf.util.ThemeUtilities;
import jakarta.faces.context.FacesContext;
import java.io.Serializable;

public final class RepeatUnit
implements Serializable {
    private static final long serialVersionUID = -8055799403044778734L;
    public static final String HOURS = "HOURS";
    public static final String DAYS = "DAYS";
    public static final String WEEKS = "WEEKS";
    public static final String MONTHS = "MONTHS";
    private static final boolean DEBUG = false;
    private static RepeatUnit hoursRi = null;
    private static RepeatUnit daysRi = null;
    private static RepeatUnit weeksRi = null;
    private static RepeatUnit monthsRi = null;
    private Integer calField = null;
    private String key = null;
    private String representation = null;

    public RepeatUnit() {
    }

    private RepeatUnit(int newCalField, String newKey, String newRepresentation) {
        this.calField = newCalField;
        this.key = newKey;
        this.representation = newRepresentation;
    }

    public static RepeatUnit getInstance(String newRepresentation) {
        if (newRepresentation.equals(HOURS)) {
            if (hoursRi == null) {
                hoursRi = new RepeatUnit(11, "Scheduler.hours", HOURS);
            }
            return hoursRi;
        }
        if (newRepresentation.equals(DAYS)) {
            if (daysRi == null) {
                daysRi = new RepeatUnit(5, "Scheduler.days", DAYS);
            }
            return daysRi;
        }
        if (newRepresentation.equals(WEEKS)) {
            if (weeksRi == null) {
                weeksRi = new RepeatUnit(3, "Scheduler.weeks", WEEKS);
            }
            return weeksRi;
        }
        if (newRepresentation.equals(MONTHS)) {
            if (monthsRi == null) {
                monthsRi = new RepeatUnit(2, "Scheduler.months", MONTHS);
            }
            return monthsRi;
        }
        return null;
    }

    public Integer getCalendarField() {
        return this.calField;
    }

    public void setCalendarField(Integer newCalField) {
        this.calField = newCalField;
    }

    public void setKey(String newKey) {
        this.key = newKey;
    }

    public String getKey() {
        return this.key;
    }

    public void setRepresentation(String newRepresentation) {
        this.representation = newRepresentation;
    }

    public String getRepresentation() {
        return this.representation;
    }

    public String getLabel(FacesContext context) {
        return ThemeUtilities.getTheme(context).getMessage(this.key);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof RepeatUnit)) {
            return false;
        }
        RepeatUnit ru = (RepeatUnit)object;
        if (this.getKey() == null ? ru.getKey() != null : !this.getKey().equals(ru.getKey())) {
            return false;
        }
        if (this.getRepresentation() == null ? ru.getRepresentation() != null : !this.getRepresentation().equals(ru.getRepresentation())) {
            return false;
        }
        return !(this.getCalendarField() == null ? ru.getCalendarField() != null : !this.getCalendarField().equals(ru.getCalendarField()));
    }

    public int hashCode() {
        int hash = 7;
        hash = 29 * hash;
        if (this.calField != null) {
            hash += this.calField.hashCode();
        }
        hash = 29 * hash;
        if (this.key != null) {
            hash += this.key.hashCode();
        }
        hash = 29 * hash;
        if (this.representation != null) {
            hash += this.representation.hashCode();
        }
        return hash;
    }

    private static void log(String msg) {
        LogUtil.finest(RepeatUnit.class.getName() + "::" + msg);
    }
}

