/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.epicyro.config.factory.file;

import java.security.Security;
import java.util.ArrayList;
import java.util.List;
import org.glassfish.epicyro.config.factory.BaseAuthConfigFactory;
import org.glassfish.epicyro.config.factory.file.AuthConfigProviderEntry;
import org.glassfish.epicyro.config.factory.file.RegStoreFileParser;

public class AuthConfigFileFactory
extends BaseAuthConfigFactory {
    public static final String DEFAULT_FACTORY_DEFAULT_PROVIDERS = "authconfigprovider.factory.providers";
    private static volatile RegStoreFileParser regStore;

    public AuthConfigFileFactory() {
        if (this.doReadLocked(() -> regStore != null).booleanValue()) {
            return;
        }
        String userDir = System.getProperty("user.dir");
        String defaultProviderString = Security.getProperty(DEFAULT_FACTORY_DEFAULT_PROVIDERS);
        this.doWriteLocked(() -> {
            if (regStore == null) {
                regStore = new RegStoreFileParser(userDir, "auth.conf", this.getDefaultProviders(defaultProviderString));
                this._loadFactory();
            }
        });
    }

    @Override
    protected RegStoreFileParser getRegStore() {
        return this.doReadLocked(() -> regStore);
    }

    private List<AuthConfigProviderEntry> getDefaultProviders(String defaultProviderString) {
        if (defaultProviderString == null) {
            return null;
        }
        ArrayList<AuthConfigProviderEntry> defaultProviders = new ArrayList<AuthConfigProviderEntry>();
        for (String defaultProviderClassName : defaultProviderString.split(" ")) {
            defaultProviders.add(new AuthConfigProviderEntry(defaultProviderClassName));
        }
        return defaultProviders;
    }
}

