/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.server;

import org.glassfish.grizzly.ThreadCache;

public final class SuspendStatus {
    private static final ThreadCache.CachedTypeIndex<SuspendStatus> CACHE_IDX = ThreadCache.obtainIndex(SuspendStatus.class, (int)4);
    private State state;
    private final Thread initThread = Thread.currentThread();

    public static SuspendStatus create() {
        SuspendStatus status = (SuspendStatus)ThreadCache.takeFromCache(CACHE_IDX);
        if (status == null) {
            status = new SuspendStatus();
        }
        assert (status.initThread == Thread.currentThread());
        status.state = State.NOT_SUSPENDED;
        return status;
    }

    private SuspendStatus() {
    }

    public void suspend() {
        assert (Thread.currentThread() == this.initThread);
        if (this.state != State.NOT_SUSPENDED) {
            throw new IllegalStateException("Can not suspend. Expected suspend state='" + State.NOT_SUSPENDED + "' but was '" + this.state + "'");
        }
        this.state = State.SUSPENDED;
    }

    boolean getAndInvalidate() {
        assert (Thread.currentThread() == this.initThread);
        boolean wasSuspended = this.state == State.SUSPENDED;
        this.state = State.INVALIDATED;
        ThreadCache.putToCache((Thread)this.initThread, CACHE_IDX, (Object)this);
        return wasSuspended;
    }

    public void reset() {
        assert (Thread.currentThread() == this.initThread);
        this.state = State.NOT_SUSPENDED;
    }

    private static enum State {
        NOT_SUSPENDED,
        SUSPENDED,
        INVALIDATED;

    }
}

